{type:"class",attributes:{"name":"Spacer","packageName":"qx.ui.core","superClass":"qx.ui.core.LayoutItem","fullName":"qx.ui.core.Spacer","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A Spacer is a &#8220;virtual&#8221; widget, which can be placed into any layout and takes\nthe space a normal widget of the same size would take.</p>\n\n<p>Spacers are invisible and very light weight because they don&#8217;t require any\n<span class=\"caps\">DOM</span> modifications.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  var container = new qx.ui.container.Composite(new qx.ui.layout.HBox());\n  container.add(new qx.ui.core.Widget());\n  conainer.add(new qx.ui.core.Spacer(50));\n  container.add(new qx.ui.core.Widget());\n</pre>\n\n<p>This example places two widgets and a spacer into a container with a\nhorizontal box layout. In this scenario the spacer creates an empty area of\n50 pixel width between the two widgets.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/widget/Spacer\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo wiki.</a>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"width"},children:[{type:"desc",attributes:{"text":"<p>the initial width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"height"},children:[{type:"desc",attributes:{"text":"<p>the initial height</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"name":"addChildrenToQueue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"queue"},children:[{type:"desc",attributes:{"text":"<p>The queue to add widgets to</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Recursively adds all children to the given queue</p>"}}]},{type:"method",attributes:{"access":"internal","isInternal":"true","name":"checkAppearanceNeeds"},children:[{type:"desc",attributes:{"text":"<p>Helper method called from the visibility queue to detect outstanding changes\nto the appearance.</p>"}}]},{type:"method",attributes:{"name":"destroy"},children:[{type:"desc",attributes:{"text":"<p>Removes this widget from its parent and dispose it.</p>\n\n<p>Please note that the widget is not disposed synchronously. The\nreal dispose happens after the next queue flush.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}