{type:"class",attributes:{"name":"Iframe","packageName":"qx.ui.embed","mixins":"qx.ui.core.MNativeOverflow","superClass":"qx.ui.core.Widget","fullName":"qx.ui.embed.Iframe","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Container widget for internal frames (iframes).\nAn iframe can display any <span class=\"caps\">HTML</span> page inside the widget.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\nvar document = this.getRoot();\nvar iframe = new qx.ui.embed.Iframe(\"http://www.qooxdoo.org\");\ndocument.add(iframe);\n</pre>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/widget/iframe\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo wiki.</a>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">URL</span> which should initally set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new instance of Iframe.</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"load"},children:[{type:"desc",attributes:{"text":"<p>The &#8220;load&#8221; event is fired after the iframe content has successfully been loaded.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.embed.Iframe#frameName","name":"_applyFrameName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>frameName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyFrameName}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.embed.Iframe#source","name":"_applySource"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySource}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_createBlockerElement"},children:[{type:"desc",attributes:{"text":"<p>Creates <div> element which is aligned over iframe node to avoid losing mouse events.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Blocker element node</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createContentElement"}},{type:"method",attributes:{"access":"protected","name":"_onIframeLoad"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Native load event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Reacts on native load event and redirects it to the widget.</p>"}}]},{type:"method",attributes:{"name":"block"},children:[{type:"desc",attributes:{"text":"<p>Cover the iframe with a transparent blocker div element. This prevents\nmouse or key events to be handled by the iframe. To release the blocker\nuse {@link #release}.</p>"}}]},{type:"method",attributes:{"name":"getBody"},children:[{type:"desc",attributes:{"text":"<p>Get the <span class=\"caps\">HTML</span> body element of the iframe.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> node of the <code>body</code> element of the iframe.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"name":"getDocument"},children:[{type:"desc",attributes:{"text":"<p>Get the <span class=\"caps\">DOM</span> document object of an iframe.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> document object of the iframe.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DOMDocument"}}]}]}]},{type:"method",attributes:{"name":"getFrameName","fromProperty":"frameName"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>frameName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #frameName}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>frameName</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getName"},children:[{type:"desc",attributes:{"text":"<p>Get the current name.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The iframe&#8217;s name.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getSource","fromProperty":"source"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>source</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getWindow"},children:[{type:"desc",attributes:{"text":"<p>Get the <span class=\"caps\">DOM</span> window object of an iframe.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">DOM</span> window object of the iframe.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"DOMWindow"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initFrameName","fromProperty":"frameName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>frameName</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>frameName</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #frameName}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSource","fromProperty":"source"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>source</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>source</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"release"},children:[{type:"desc",attributes:{"text":"<p>Release the blocker set by {@link #block}.</p>"}}]},{type:"method",attributes:{"name":"reload"},children:[{type:"desc",attributes:{"text":"<p>Reload the contents of the iframe.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.Widget","name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"}},{type:"param",attributes:{"name":"top"}},{type:"param",attributes:{"name":"width"}},{type:"param",attributes:{"name":"height"}}]}]},{type:"method",attributes:{"name":"resetFrameName","fromProperty":"frameName"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>frameName</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #frameName}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSource","fromProperty":"source"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>source</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setFrameName","fromProperty":"frameName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>frameName</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>frameName</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #frameName}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSource","fromProperty":"source"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>source</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>source</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #source}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"iframe\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"check":"String","apply":"_applyFrameName","defaultValue":"\"\"","name":"frameName","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Name of the iframe.</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applySource","check":"String","name":"source","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Source <span class=\"caps\">URL</span> of the iframe.</p>"}}]}]}]}