{type:"class",attributes:{"name":"Tree","packageName":"qx.ui.tree","mixins":"qx.ui.core.MSelectionHandling,qx.ui.core.MContentPadding","superClass":"qx.ui.core.AbstractScrollArea","fullName":"qx.ui.tree.Tree","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The Tree class implements a tree widget, with collapsable and expandable\ncontainer nodes and terminal leaf nodes. You instantiate a Tree object and\nthen assign the tree a root folder using the {@link #root} property.</p>\n\n<p>If you don&#8217;t want to show the root item, you can hide it with the\n{@link #hideRoot} property.</p>\n\n<p>The handling of <b>selections</b> within a tree is somewhat distributed\nbetween the root tree object and the attached {@link\nqx.ui.tree.SelectionManager TreeSelectionManager}. To get the\ncurrently selected element of a tree use the tree {@link #getSelectedItem\ngetSelectedItem} method and tree {@link #setSelectedItem\nsetSelectedItem} to set it. The TreeSelectionManager handles more\ncoars-grained issues like providing selectAll()/deselectAll() methods.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.AbstractScrollArea","isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"addItem"},children:[{type:"desc",attributes:{"text":"<p>This event is fired after a tree item was added to the tree. The\n{@link qx.event.type.Data#getData} method of the event returns the\nadded item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeOpenMode"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #openMode}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeRoot"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #root}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"removeItem"},children:[{type:"desc",attributes:{"text":"<p>This event is fired after a tree item has been removed from the tree.\nThe {@link qx.event.type.Data#getData} method of the event returns the\nremoved item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.Tree#hideRoot","name":"_applyHideRoot"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>hideRoot</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyHideRoot}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.Tree#openMode","name":"_applyOpenMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>openMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyOpenMode}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.Tree#root","name":"_applyRoot"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tree.AbstractTreeItem"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tree.AbstractTreeItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>root</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyRoot}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tree.Tree#rootOpenClose","name":"_applyRootOpenClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>rootOpenClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyRootOpenClose}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_getContentPaddingTarget"},children:[{type:"desc",attributes:{"text":"<p>Returns the element, to which the content padding should be applied.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The content padding target.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The mouse click event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event hander for click events, which could change a tree item&#8217;s open\nstate.</p>"}}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","name":"getChildrenContainer"},children:[{type:"desc",attributes:{"text":"<p>Get the widget, which containes the root tree item. This widget must\nhave a vertical box layout.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the children container</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getHideRoot","fromProperty":"hideRoot"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>hideRoot</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>hideRoot</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getItems"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"false","name":"recursive"},children:[{type:"desc",attributes:{"text":"<p>whether children of subfolder should be\n    included</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"invisible"},children:[{type:"desc",attributes:{"text":"<p>whether invisible children should be\n    included</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns all children of the tree.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>list of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem","dimensions":"1"}}]}]}]},{type:"method",attributes:{"name":"getNextSiblingOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>The tree item to get the item after</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"invisible"},children:[{type:"desc",attributes:{"text":"<p>Whether invisible/closed tree items\n    should be returned as well.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the tree item after the given item</p>"}},{type:"return",attributes:{"defaultValue":"null"},children:[{type:"desc",attributes:{"text":"<p>The item after the given item. May be\n    <code>null</code> if the item is the last item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"method",attributes:{"name":"getOpenMode","fromProperty":"openMode"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>openMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>openMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPreviousSiblingOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"treeItem"},children:[{type:"desc",attributes:{"text":"<p>The tree item to get the item before</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]},{type:"param",attributes:{"defaultValue":"true","name":"invisible"},children:[{type:"desc",attributes:{"text":"<p>Whether invisible/closed tree items\n    should be returned as well.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the tree item before the given item</p>"}},{type:"return",attributes:{"defaultValue":"null"},children:[{type:"desc",attributes:{"text":"<p>The item before the given item. May be\n    <code>null</code> if the item is the first item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}}]}]}]},{type:"method",attributes:{"name":"getRoot","fromProperty":"root"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>root</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #root}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>root</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>rootOpenClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>rootOpenClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getTreeItem"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to get the containing tree\n  item for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the tree item, which contains the given widget.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The tree item containing the widget. If the\n    widget is not inside of any tree item <code>null</code> is returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"AbstractTreeItem"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initHideRoot","fromProperty":"hideRoot"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>hideRoot</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>hideRoot</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOpenMode","fromProperty":"openMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>openMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>openMode</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #openMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initRoot","fromProperty":"root"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>root</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>root</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #root}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>rootOpenClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>rootOpenClose</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isHideRoot","fromProperty":"hideRoot"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>hideRoot</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>rootOpenClose</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"resetHideRoot","fromProperty":"hideRoot"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>hideRoot</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetOpenMode","fromProperty":"openMode"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>openMode</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #openMode}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetRoot","fromProperty":"root"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>root</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #root}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>rootOpenClose</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"scrollChildIntoViewY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"}},{type:"param",attributes:{"name":"align"}},{type:"param",attributes:{"name":"direct"}}]}]},{type:"method",attributes:{"name":"setHideRoot","fromProperty":"hideRoot"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>hideRoot</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>hideRoot</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setOpenMode","fromProperty":"openMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>openMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>openMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setRoot","fromProperty":"root"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>root</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>root</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #root}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>rootOpenClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>rootOpenClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleHideRoot","fromProperty":"hideRoot"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>hideRoot</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #hideRoot}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleRootOpenClose","fromProperty":"rootOpenClose"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>rootOpenClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #rootOpenClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"tree\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.AbstractScrollArea"}},{type:"property",attributes:{"name":"focusable","docFrom":"qx.ui.core.Widget","defaultValue":"true","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"check":"Boolean","apply":"_applyHideRoot","defaultValue":"false","name":"hideRoot","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Hide the root (Tree) node.  This differs from the visibility property in\nthat this property hides <strong>only</strong> the root node, not the node&#8217;s children.</p>"}}]},{type:"property",attributes:{"name":"openMode","defaultValue":"\"dblclick\"","propertyType":"new","apply":"_applyOpenMode","possibleValues":"\"click\",\"dblclick\",\"none\"","event":"changeOpenMode","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Control whether clicks or double clicks should open or close the clicked\nfolder.</p>"}}]},{type:"property",attributes:{"name":"root","defaultValue":"null","event":"changeRoot","allowNull":"true","propertyType":"new","apply":"_applyRoot","check":"qx.ui.tree.AbstractTreeItem"},children:[{type:"desc",attributes:{"text":"<p>The root tree item of the tree to display</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyRootOpenClose","defaultValue":"false","name":"rootOpenClose","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether the Root should have an open/close button.  This may also be\n used in conjunction with the hideNode property to provide for virtual root\n nodes.  In the latter case, be very sure that the virtual root nodes are\n expanded programatically, since there will be no open/close button for the\n user to open them.</p>"}}]}]}]}