{type:"class",attributes:{"name":"Window","packageName":"qx.ui.window","mixins":"qx.ui.core.MRemoteChildrenHandling,qx.ui.core.MRemoteLayoutHandling,qx.ui.core.MResizable,qx.ui.core.MMovable,qx.ui.core.MContentPadding","superClass":"qx.ui.core.Widget","childClasses":"calc.Calculator","fullName":"qx.ui.window.Window","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A window widget</p>\n\n<p>More information can be found in the package description {@link qx.ui.window}.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"caption"},children:[{type:"desc",attributes:{"text":"<p>The caption text</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"icon"},children:[{type:"desc",attributes:{"text":"<p>The <span class=\"caps\">URL</span> of the caption bar icon</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"DEFAULT_MANAGER_CLASS"},children:[{type:"desc",attributes:{"text":"<p>The default window manager class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"beforeClose"},children:[{type:"desc",attributes:{"text":"<p>Fired before the window is closed.</p>\n\n<p>The close action can be prevented by calling\n{@link qx.event.type.Event#preventDefault} on the event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeMaximize"},children:[{type:"desc",attributes:{"text":"<p>Fired before the window is maximize.</p>\n\n<p>The maximize action can be prevented by calling\n{@link qx.event.type.Event#preventDefault} on the event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeMinimize"},children:[{type:"desc",attributes:{"text":"<p>Fired before the window is minimize.</p>\n\n<p>The minimize action can be prevented by calling\n{@link qx.event.type.Event#preventDefault} on the event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"beforeRestore"},children:[{type:"desc",attributes:{"text":"<p>Fired before the window is restored from a minimized or maximized state.</p>\n\n<p>The restored action can be prevented by calling\n{@link qx.event.type.Event#preventDefault} on the event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"changeActive"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #active}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeCaption"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #caption}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeIcon"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #icon}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeModal"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #modal}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeStatus"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #status}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"close"},children:[{type:"desc",attributes:{"text":"<p>Fired if the window is closed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"maximize"},children:[{type:"desc",attributes:{"text":"<p>Fired if the window is maximized</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"minimize"},children:[{type:"desc",attributes:{"text":"<p>Fired if the window is minimized</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"restore"},children:[{type:"desc",attributes:{"text":"<p>Fired if the window is restored from a minimized or maximized state</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#active","name":"_applyActive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyActive}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#caption","name":"_applyCaption"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>caption</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyCaption}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#allowMaximize","name":"_applyCaptionBarChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>showClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyCaptionBarChange}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#icon","name":"_applyIcon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyIcon}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#showStatusbar","name":"_applyShowStatusbar"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>showStatusbar</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyShowStatusbar}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.Window#status","name":"_applyStatus"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>status</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyStatus}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_getContentPaddingTarget"},children:[{type:"desc",attributes:{"text":"<p>Returns the element, to which the content padding should be applied.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The content padding target.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onCaptionMouseDblClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>double click event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Maximizes the window or restores it if it is already\nmaximized.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onCloseButtonClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouse click event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Closes the window, removes all states from the close button and\nstops the further propagation of the event (calling {@link qx.event.type.Event#stopPropagation}).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onMaximizeButtonClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouse click event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Maximizes the window, removes all states from the maximize button and\nstops the further propagation of the event (calling {@link qx.event.type.Event#stopPropagation}).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onMinimizeButtonClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouse click event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Minimizes the window, removes all states from the minimize button and\nstops the further propagation of the event (calling {@link qx.event.type.Event#stopPropagation}).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onRestoreButtonClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouse click event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Restores the window, removes all states from the restore button and\nstops the further propagation of the event (calling {@link qx.event.type.Event#stopPropagation}).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onWindowEventStop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>any event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Stops every event</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onWindowFocusOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>focus event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Focus"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listens to the &#8220;focusout&#8221; event to deactivate the window (if the \ncurrently focused widget is not a child of the window)</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onWindowMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouse down event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Focuses the window instance.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_updateCaptionBar"},children:[{type:"desc",attributes:{"text":"<p>Updates the status and the visibility of each element of the captionbar.</p>"}}]},{type:"method",attributes:{"name":"center"},children:[{type:"desc",attributes:{"text":"<p>Centers the window to the parent.</p>\n\n<p>This call works with the the size of the parent widget and the size of\nthe window as calculated in the last layout flush. It is best to call\nthis method just after rendering the window in the &#8220;resize&#8221; event:</p>\n\n<pre class=\"javascript\">\n  win.addListenerOnce(\"resize\", this.center, this);\n</pre>"}}]},{type:"method",attributes:{"name":"close"},children:[{type:"desc",attributes:{"text":"<p>Closes the current window instance.\nTechnically calls the {@link qx.ui.core.Widget#hide} method.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getActive","fromProperty":"active"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>active</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowClose","fromProperty":"allowClose"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getCaption","fromProperty":"caption"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>caption</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #caption}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>caption</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","name":"getChildrenContainer"},children:[{type:"desc",attributes:{"text":"<p>The children container needed by the {@link qx.ui.core.MRemoteChildrenHandling}\nmixin</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>pane sub widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.container.Composite"}}]}]}]},{type:"method",attributes:{"name":"getIcon","fromProperty":"icon"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getModal","fromProperty":"modal"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>modal</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>modal</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMode"},children:[{type:"desc",attributes:{"text":"<p>Return the window mode as <code>String</code>:\n<code>&#8220;maximized&#8221;</code>, <code>&#8220;normal&#8221;</code> or <code>&#8220;minimized&#8221;</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The window mode as <code>String</code> value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getShowClose","fromProperty":"showClose"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>showClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>showClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getShowMaximize","fromProperty":"showMaximize"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>showMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>showMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getShowMinimize","fromProperty":"showMinimize"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>showMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>showMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>showStatusbar</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>showStatusbar</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getStatus","fromProperty":"status"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>status</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #status}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>status</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initActive","fromProperty":"active"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>active</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>active</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowClose","fromProperty":"allowClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowClose</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowMaximize</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowMinimize</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initCaption","fromProperty":"caption"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>caption</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>caption</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #caption}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initIcon","fromProperty":"icon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>icon</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initModal","fromProperty":"modal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>modal</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>modal</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShowClose","fromProperty":"showClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>showClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>showClose</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShowMaximize","fromProperty":"showMaximize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>showMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>showMaximize</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShowMinimize","fromProperty":"showMinimize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>showMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>showMinimize</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>showStatusbar</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>showStatusbar</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initStatus","fromProperty":"status"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>status</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>status</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #status}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isActive","fromProperty":"active"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>active</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowClose","fromProperty":"allowClose"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowClose</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowMaximize</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowMinimize</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isMaximized"},children:[{type:"desc",attributes:{"text":"<p>Return <code>true</code> if the window is in maximized state, \nbut note that the window in maximized state could also be invisible, this \nis equivalent to minimized. So use the {@link qx.ui.window.Window#getMode}\nto get the window mode.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> if the window is maximized, \n  <code>false</code> otherwise."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isModal","fromProperty":"modal"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>modal</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isShowClose","fromProperty":"showClose"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>showClose</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isShowMaximize","fromProperty":"showMaximize"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>showMaximize</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isShowMinimize","fromProperty":"showMinimize"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>showMinimize</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>showStatusbar</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"maximize"},children:[{type:"desc",attributes:{"text":"<p>Maximize the window.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"minimize"},children:[{type:"desc",attributes:{"text":"<p>Minimized the window.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"moveTo"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"},children:[{type:"desc",attributes:{"text":"<p>The left position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"top"},children:[{type:"desc",attributes:{"text":"<p>The top position</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set the window&#8217;s position relative to its parent</p>"}}]},{type:"method",attributes:{"name":"open"},children:[{type:"desc",attributes:{"text":"<p>Opens the window.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetActive","fromProperty":"active"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>active</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowClose","fromProperty":"allowClose"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowClose</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowMaximize</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowMinimize</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetCaption","fromProperty":"caption"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>caption</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #caption}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetIcon","fromProperty":"icon"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>icon</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetModal","fromProperty":"modal"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>modal</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShowClose","fromProperty":"showClose"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>showClose</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShowMaximize","fromProperty":"showMaximize"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>showMaximize</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShowMinimize","fromProperty":"showMinimize"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>showMinimize</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>showStatusbar</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetStatus","fromProperty":"status"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>status</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #status}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"restore"},children:[{type:"desc",attributes:{"text":"<p>Restore the window, if it is maximized.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setActive","fromProperty":"active"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>active</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowClose","fromProperty":"allowClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setCaption","fromProperty":"caption"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>caption</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>caption</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #caption}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setIcon","fromProperty":"icon"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>icon</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>icon</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #icon}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.core.LayoutItem","overriddenFrom":"qx.ui.core.Widget","name":"setLayoutParent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"}}]}]},{type:"method",attributes:{"name":"setModal","fromProperty":"modal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>modal</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>modal</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShowClose","fromProperty":"showClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>showClose</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>showClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShowMaximize","fromProperty":"showMaximize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>showMaximize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>showMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShowMinimize","fromProperty":"showMinimize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>showMinimize</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>showMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>showStatusbar</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>showStatusbar</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setStatus","fromProperty":"status"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>status</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>status</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #status}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleActive","fromProperty":"active"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>active</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #active}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowClose","fromProperty":"allowClose"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowMaximize","fromProperty":"allowMaximize"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowMinimize","fromProperty":"allowMinimize"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleModal","fromProperty":"modal"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>modal</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #modal}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleShowClose","fromProperty":"showClose"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>showClose</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showClose}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleShowMaximize","fromProperty":"showMaximize"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>showMaximize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMaximize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleShowMinimize","fromProperty":"showMinimize"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>showMinimize</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showMinimize}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleShowStatusbar","fromProperty":"showStatusbar"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>showStatusbar</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #showStatusbar}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"active","defaultValue":"false","event":"changeActive","propertyType":"new","apply":"_applyActive","check":"Boolean"},children:[{type:"desc",attributes:{"text":"<p>If the window is active, only one window in a single qx.ui.window.Manager could\n have set this to true at the same time.</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyCaptionBarChange","defaultValue":"true","name":"allowClose","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Should the user have the ability to close the window</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyCaptionBarChange","defaultValue":"true","name":"allowMaximize","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Should the user have the ability to maximize the window</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyCaptionBarChange","defaultValue":"true","name":"allowMinimize","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Should the user have the ability to minimize the window</p>"}}]},{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"window\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"allowNull":"true","apply":"_applyCaption","event":"changeCaption","name":"caption","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The text of the caption</p>"}}]},{type:"property",attributes:{"name":"focusable","docFrom":"qx.ui.core.Widget","defaultValue":"true","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"name":"icon","check":"String","allowNull":"true","propertyType":"new","apply":"_applyIcon","event":"changeIcon","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The icon of the caption</p>"}}]},{type:"property",attributes:{"event":"changeModal","defaultValue":"false","check":"Boolean","name":"modal","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Should the window be modal (this disables minimize and maximize buttons)</p>"}}]},{type:"property",attributes:{"name":"showClose","defaultValue":"true","propertyType":"new","apply":"_applyCaptionBarChange","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Should the close button be shown</p>"}}]},{type:"property",attributes:{"name":"showMaximize","defaultValue":"true","propertyType":"new","apply":"_applyCaptionBarChange","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Should the maximize button be shown</p>"}}]},{type:"property",attributes:{"name":"showMinimize","defaultValue":"true","propertyType":"new","apply":"_applyCaptionBarChange","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Should the minimize button be shown</p>"}}]},{type:"property",attributes:{"check":"Boolean","apply":"_applyShowStatusbar","defaultValue":"false","name":"showStatusbar","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Should the statusbar be shown</p>"}}]},{type:"property",attributes:{"name":"status","check":"String","allowNull":"true","propertyType":"new","apply":"_applyStatus","event":"changeStatus"},children:[{type:"desc",attributes:{"text":"<p>The text of the statusbar</p>"}}]},{type:"property",attributes:{"name":"visibility","docFrom":"qx.ui.core.Widget","defaultValue":"\"excluded\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}}]}]}