{type:"class",attributes:{"hasError":"true","name":"TimerManager","hasWarning":"true","packageName":"qx.util","superClass":"qx.core.Object","isSingleton":"true","fullName":"qx.util.TimerManager","type":"class"},children:[{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__insertNewTimer"},children:[{type:"params",children:[{type:"param",attributes:{"name":"expireAt"},children:[{type:"desc",attributes:{"text":"<p>Milliseconds from now when this timer should expire</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"timerId"},children:[{type:"desc",attributes:{"text":"<p>Id of the timer to be time-ordered</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Insert a timer on the time-ordered list of active timers.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"Void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__processQueue"},children:[{type:"desc",attributes:{"text":"<p>Process the queue of timers.  Call the registered callback function for\nany timer which has expired.  If the timer is marked as recurrent, the\ntimer is restarted with the recurrent timeout following completion of\nthe callback function.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"Void"}}]}]}]},{type:"method",attributes:{"name":"start"},children:[{type:"params",children:[{type:"param",attributes:{"name":"callback"},children:[{type:"desc",attributes:{"text":"<p>Function to be called upon expiration of the timer.  The function is\n  passed these parameters:\n  <dl>\n    <dt>userData</dt>\n      <dd>The user data provided to the start() method</dd>\n    <dt>timerId</dt>\n      <dd>The timer id, as was returned by the start() method</dd>\n  </dl></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"recurTime"},children:[{type:"desc",attributes:{"text":"<p>If null, the timer will not recur.  Once the callback function\n  returns the first time, the timer will be removed from the timer\n  queue.  If non-null, upon return from the callback function, the\n  timer will be reset to this number of milliseconds.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}},{type:"entry",attributes:{"type":"null"}}]}]},{type:"param",attributes:{"name":"context"},children:[{type:"desc",attributes:{"text":"<p>Context (this) the callback function is called with.  If not\n  provided, this Timer singleton object is used.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Object"}},{type:"entry",attributes:{"type":"null"}}]}]},{type:"param",attributes:{"name":"userData"},children:[{type:"desc",attributes:{"text":"<p>Data which is passed to the callback function upon timer expiry</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Any"}}]}]},{type:"param",attributes:{"name":"initialTime"},children:[{type:"desc",attributes:{"text":"<p>Milliseconds before the callback function is called the very first\n  time.  If not specified and recurTime is specified, then recurTime\n  will be used as initialTime; otherwise initialTime will default\n  to zero.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"desc",attributes:{"text":"<p>Start a new timer</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The timer id of this unique timer.  It may be provided to the stop()\n  method to cancel a timer before expiration.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"stop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"timerId"},children:[{type:"desc",attributes:{"text":"<p>A timer id previously returned by start()</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Stop a running timer</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<i>true</i> if the specified timer id was found (and removed);\n  <i>false</i> if no such timer was found (i.e. it had already expired)"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"getInstance"},children:[{type:"desc",attributes:{"text":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The singleton instance of this class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.TimerManager"}}]}]}]}]},{type:"errors",children:[{type:"error",attributes:{"msg":"Class documentation is missing.","column":"16","line":"74"}}]}]}