﻿// PNRP Beacon - Ein PNRP Beispielprogramm
// benoetigt .NET Runtime 3.5 SP1 oder neuer
// Windows 2008 Server oder Vista mit PNRP 
// IPv6 Netzwerkanbindung
//
// 12/2008 Carsten Strotmann
// (c) 2008 c't Magazin, Heise Verlag
//

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Net;
using System.Net.PeerToPeer;
using System.Threading;
using System.Windows.Threading;
using System.Windows;

namespace PnrpBeacon
{
    // eine simple Logging-Klasse fuer Logmeldungen im Anwendungsfenster
    internal class PnrpLogentry : DispatcherObject, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        
        // Aenderungen per Event an die UI (WPF) weitergeben
        protected void Notify(String propName)
        {
            if (this.PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
            }
        }

        // ein Log-Eintrag
        private string entry;
        public string Entry
        {
            get { 
                return this.entry; 
            }
            set
            {
                this.entry = value;
                Notify("Entry");
            }
        }

        public PnrpLogentry() { }
        public PnrpLogentry(string entry)
        {
            this.entry = entry;
        }
    }

    // Eine Collection aus Log-Eintraegen
    // kann per Data-Binding an eine UI-Liste
    // gekoppelt werden
    internal class PnrpLog : ObservableCollection<PnrpLogentry> {
        
        // einen neuen Logeintrag an das Log anfuegen
        public void append(String entry) {
            if (Application.Current != null)
            {
                // Aufruf an den UI-Thread weiterleiten
                // UI-Aenderungen muessen im UI-Thread aus-
                // gefuehrt werden
                if (Thread.CurrentThread != Application.Current.Dispatcher.Thread)
                    Application.Current.Dispatcher.Invoke(DispatcherPriority.Normal, (ThreadStart)delegate { append(entry); });
                else
                {
                    this.Add(new PnrpLogentry(entry));
                    System.Diagnostics.Debug.WriteLine("Log entry:" + entry);
                }
            }
            else
            {
                System.Diagnostics.Debug.WriteLine("Log entry:" + entry);
            }
        }
    }
}
