﻿// PNRP Beacon - Ein PNRP Beispielprogramm
// benoetigt .NET Runtime 3.5 SP1 oder neuer
// Windows 2008 Server oder Vista mit PNRP 
// IPv6 Netzwerkanbindung
//
// 12/2008 Carsten Strotmann
// (c) 2008 c't Magazin, Heise Verlag
//

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.PeerToPeer;
using System.Threading;

namespace PnrpBeacon
{
    // eine simple Wrapper-Klasse um PNRP Registrierungen zu 
    // verwalten
    internal class PnrpRegistrations
    {
        // Hashtabelle um PNRP Registrierungen zu speichern
        // Schluessel: PNRP Topic Name
        // Wert: PNRP Registrierungs-Objekt
        internal Hashtable registrations = new Hashtable();

        // PNRP-Registrieung der Hashtabelle hinzufuegen
        internal void addRegistration(String topic, PeerNameRegistration pnReg)
        {
            registrations.Add(topic.ToLower(), pnReg);
        }

        // Hashtabelle uebergeben
        internal Hashtable getRegistrations()
        {
            return registrations;
        }

        // PNRP-Registrierung aus der Hashtabelle loeschen
        internal void removeRegistration(String topic)
        {
            registrations.Remove(topic.ToLower());
        }

        // liefert eine Registrierung anhand des Topic-Namens zurueck
        internal PeerNameRegistration getRegistration(String topic)
        {
            return (PeerNameRegistration)registrations[topic.ToLower()];
        }
    }
}
