Attribute VB_Name = "Geburtstag"
Sub GeburtstagsErinnerungndern()
    Dim objTerminordner As MAPIFolder
    Dim objTermin As AppointmentItem
    Dim intButton As Integer

    'Auf Terminordner verweisen
    Set objTerminordner = Application.GetNamespace("MAPI") _
        .GetDefaultFolder(olFolderCalendar)
    
    'Alle Termine durchlaufen
    For Each objTermin In objTerminordner.Items
        'Wenn Termin ein Serientermin ist und...
        If objTermin.IsRecurring Then
            '... sein Betreff mit "Geburtstag" beginnt, dann...
            If InStr(objTermin.Subject, "Geburtstag") = 1 Then
                '... nachfragen, ob Erinnerung gendert werden soll
                intButton = MsgBox(objTermin.Subject & vbCr & _
                    "Erinnerung auf 12 Stunden vor Mitternacht setzen?", _
                    vbYesNoCancel)
                'Wenn die Antwort 'Ja' lautet, dann...
                If intButton = vbYes Then
                    With objTermin
                        '... Erinnerung aktivieren
                        .ReminderSet = True
                        'Erinnerung auf 12 Stunden vor Flligkeit setzen
                        .ReminderMinutesBeforeStart = 720
                        'Genderte Zeit in alle Einzeltermine bernehmen
                        .ReminderOverrideDefault = True
                        'Vernderung speichern
                        .Save
                    End With
                'Wenn die Antwort 'Abbrechen' lautet, dann...
                ElseIf intButton = vbCancel Then
                    '... Schleife verlassen
                    Exit For
                End If
            End If
        End If
    Next
End Sub

Sub GeburtstagsErinnerungndernOhneNachfrage()
    Dim objTerminordner As MAPIFolder
    Dim objTermin As AppointmentItem
    Dim intZhler As Integer

    'Auf Terminordner verweisen
    Set objTerminordner = Application.GetNamespace("MAPI") _
        .GetDefaultFolder(olFolderCalendar)
    
    'Alle Termine durchlaufen
    For Each objTermin In objTerminordner.Items
        'Wenn Termin ein Serientermin ist und...
        If objTermin.IsRecurring Then
            '... sein Betreff mit "Geburtstag" beginnt, dann...
            If InStr(objTermin.Subject, "Geburtstag") = 1 Then
                With objTermin
                    '... Erinnerung aktivieren
                    .ReminderSet = True
                    'Erinnerung auf 12 Stunden vor Flligkeit setzen
                    .ReminderMinutesBeforeStart = 720
                    'Genderte Zeit in alle Einzeltermine bernehmen
                    .ReminderOverrideDefault = True
                    'Vernderung speichern
                    .Save
                    'Zhler erhhen
                    intZhler = intZhler + 1
                End With
            End If
        End If
    Next
    
    'Feedback ausgeben
    MsgBox "Erinnerungszeit von " & CStr(intZhler) & " Geburtstagsereignissen gendert."
End Sub

