#!/bin/bash
# unfollow 1.0
# (c) by Christiane Ruetten
# Licensed under GPLv2
# crontab example:
# @daily $HOME/unfollow.sh p4ula cr@heise.de

url='http://twitter.com'
call(){ wget -q "$url/$1.xml" -O - | xml2 ;}
tag(){ awk -F= "/${1//\//\\/}/ {print \$2}" ;}
followers(){ call "followers/ids/$1" | tag /id= ;}
name(){ call "users/show/$1" | tag /screen_name= ;}
names(){ while read id ; do name $id ; done ;}
intsect(){ cat "$1" "$2" | sort | uniq -d ;}
symdiff(){ cat "$1" "$2" | sort | uniq -u ;}
wrap(){ while read n ; do echo " $url/$n" ; done ;}

name=$1 ; email=$2
old="$HOME/.unfollow.$name.old"
new="$HOME/.unfollow.$name.new"
tmp="$HOME/.unfollow.$name.tmp"

followers $name >"$new" 2>/dev/null
[ -s "$new" ] || exit
[ -e "$old" ] || cp "$new" "$old"
symdiff "$old" "$new" >"$tmp"
[ -s "$tmp" ] || exit

(
  echo "Unfollower:"
  intsect "$old" "$tmp" | names | wrap
  echo "Neue Follower:"
  intsect "$new" "$tmp" | names | wrap
) | (
  if [ -n "$email" ]; then
    mail -s "Twitter-Status" "$email"
  else
    cat
  fi
)

mv "$new" "$old"
rm -f "$tmp" 2>/dev/null

