// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// Alle Rechte vorbehalten.
// $Id: helper.js f0b901a08412 2009/10/06 09:46:54 Oliver Lau <oliver@von-und-fuer-lau.de> $

var linkId = 0;
var linkifyEntities = { '"':'&quot;', '&':'&amp;', '<':'&lt;', '>':'&gt;' };


function linkify(s) {
	return s.replace(/(https?:\/\/[\w\.-]+\.[a-z\.]{2,6}[\/\w\.-]*\/?)( - )?/g, function(d, m1, m2) {
		var res = m1.match(/(http:\/\/([\w\.-]+)\/)(\w+)/);
		if (res) {
			var lnk      = res[1];
			var provider = res[2];
			var code     = res[3];
			if (lnk.match(/(twitgoo\.com|twitpic\.com|img\.ly|yfrog\.com|mobypicture\.com)/)) {
				var lnk2 = provider + '-' + code + '.jpg';
				return '<p><a href="' + lnk2 + '"><img src="thumb-' + lnk2 + '"></a></p>';
			}
			++linkId;
			return '<a onmouseover="tweet.mapUrl(\'lnk' +  linkId + '\')" id="lnk' + linkId + '" title="' + m1 + '" target="_blank" href="' + m1 + '">' + m1 + '</a>';
		}
		return '<a target="_blank" href="' + m1 + '">' + m1 + '</a>';
	}).replace(/(^|[^\w])(@[\d\w\-]+)/g, function(d, m1, m2) {
	    return m1 + '@<a target="_blank" href="http://twitter.com/' + m2.substr(1) + '">' + m2.substr(1) + '</a>';
	}).replace(/"&<>/, function (m) {
	    return linkifyEntities[m];
	}).replace(/(^|[^\w])(#[\d\wäöüÄÖÜáéíóúàèìòùß]+)/g, function(d, m1, m2) {
	    return m1 + '#<a target="_blank" href="http://twitter.com/search?q=' + m2.substr(1) + '">' + m2.substr(1) + '</a>';
	}).replace(/(^|[^\w])(L:([^ ,\.]+))/g, function(d, m1, m2) {
	    return m1 + '<a target="_blank" href="http://maps.google.com/maps?q=' + m2.substr(2) + '">' + m2.substr(2) + '</a>';
	});
}


function clearSubtree(node) {
    while (node.firstChild)
    	node.removeChild(node.firstChild);
}


function relative_time(time_value) {
    var values = time_value.split(' ');
    var parsed_date = Date.parse(values[1] + ' ' + values[2] + ', ' + values[5] + ' ' + values[3]);
    var date = new Date(parsed_date);
    var relative_to = (arguments.length > 1) ? arguments[1] : new Date();
    var delta = parseInt((relative_to.getTime() - parsed_date) / 1000);
    var r = '';

    function formatTime(date) {
        var hour = date.getHours();
        var min = date.getMinutes() + '';
        if (min.length == 1)
            min = '0' + min;
        return hour + ':' + min + '&nbsp;Uhr';
    }

    function formatDate(date) {
        var day = date.getDate(),
            mon = date.getMonth()+1,
            thisyear = (new Date()).getFullYear(),
            year = date.getFullYear();
        return day + '.' + mon + '.' + ((thisyear != year)? year : '');
    }

    delta += 60*relative_to.getTimezoneOffset();
    if (delta < 5) {
        r = 'vor weniger als fünf Sekunden';
    } else if (delta < 30) {
        r = 'vor einer halben Minute';
    } else if (delta < 60) {
        r = 'vor weniger als einer Minute';
    } else if (delta < 120) {
        r = 'vor gut einer Minute';
    } else if (delta < (45*60)) {
        r = 'vor ' + (parseInt(delta/60)).toString() + ' Minuten';
    } else if (delta < (2*90*60)) {
        r = 'vor etwa einer Stunde';
    } else if (delta < (24*60*60)) {
        r = 'vor etwa ' + (parseInt(delta/3600)).toString() + ' Stunden';
    } else {
        var sOffset = -60*relative_to.getTimezoneOffset();
        var tzDate = new Date(date.getTime() + 1000*sOffset);
        r = 'am ' + formatDate(tzDate) + ' um ' + formatTime(tzDate);
    }
    return r;
}


var scrollInterval = 10; // ms
var scrollDuration; // ms
var scrollTime;
var scrollTarget;
var scrollDistance;
var scroller = null;

function accel(t, b, c, d) {
    return c/2*(1-Math.cos(Math.PI*t/d))+b;
}

function scrollPage() {
	scrollTime += scrollInterval;
	if (scrollTime < scrollDuration) {
		window.scrollTo(0, accel(scrollTime, scrollTarget, scrollDistance, scrollDuration));
    }
    else {
        window.scrollTo(0, scrollTarget + scrollDistance);
        clearInterval(scroller);
        scroller = null;
    }
}

function scrollToTop(id) {
	if (document.getElementById(id)) {
		scrollTime = 0;
		var topPos = document.getElementById(id).offsetTop;
		var heightCorrection = (topPos > 20)? 20 : 0;
		if (typeof (window.pageYOffset) == 'number') {
			// Non-IE modern browsers
			scrollTarget = window.pageYOffset;
			scrollDistance = topPos - heightCorrection - scrollTarget;
			scrollDuration = 500;
		}
		else if (document.documentElement) {
			// IE in Standards Compliance mode
			scrollTarget = document.documentElement.scrollTop;
			scrollDistance = topPos - scrollTarget;
			if (window.XMLHttpRequest)
				scrollDuration = 500; // IE7
			else
				scrollDuration = 1500; // IE6
		}
		else if (document.body && (document.body.scrollLeft || document.body.scrollTop) ) {
			// DOM compliant method, IE Quirks Mode
			scrSt = document.body.scrollTop;
			scrollDistance = topPos - scrollTarget;
			scrollDuration = 500;
		}
		if (scroller)
		    clearInterval(scroller);
	    scroller = setInterval(scrollPage, scrollInterval);
	}
}
