' BedingterRuhezustand-Aktivieren.vbs 1.1 von Robert Hohmann 08/2009
' Fhrt den Rechner ber geplante Tasks nach einer bestimmten
' Zeit der Inaktivitt (Tastatur und Maus) in den Ruhezustand.
' In BedingterRuhezustand.cfg wird die Zeit in Minuten einge-
' tragen. Ausnahmen werden in der Datei Exclude.txt definiert.
' Erzeugt das Logfile BedingterRuhezustand.log.

On Error Resume Next

Set fs = CreateObject("Scripting.FileSystemObject")
Set ShellWSH = CreateObject("Wscript.Shell")
Set Env = ShellWSH.Environment("Process")
Public wochentag, von, bis, adhocexclusion
windir = Env("SYSTEMROOT") & "\"
programpath = Env("PROGRAMFILES") & "\BedingterRuhezustand\"
herunterfahren = 0
herunterfahrentext = "in den Ruhezustand"
full_logging = 1
	
' Anzahl Minuten einlesen, nach denen der Rechner in den Ruhezustand gefahren werden soll
Set CfgFile = fs.OpenTextFile(programpath & "BedingterRuhezustand.cfg", 1, true)             					
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If LCase(Trim(Left(zeile,7))) = "minuten" Then
    pos1 = InStr(zeile,"=")
    minuten = Mid(zeile,pos1+1)
    minuten = Int(minuten / 1)   ' in Zahl umwandeln
    If minuten < 1 Then minuten = 1
  End If
  If LCase(Trim(Left(zeile,30))) = "herunterfahrenstattruhezustand" Then
    pos1 = InStr(zeile,"=")
    wert = Mid(zeile,pos1+1)
    If LCase(Trim(Left(wert,4))) = "true" Then 
      herunterfahren = 1
      herunterfahrentext = "herunter"
    End If
  End If
loop


If fs.fileexists(programpath & "Ruhezustand.lock") Then   ' falls Datei Ruhezustand.lock nicht existiert
  If full_logging Then Call logging("Ruhezustand.lock existiert, fahre nicht " & herunterfahrentext & "...")
Else
  Set Flag = fs.OpenTextFile(programpath & "Ruhezustand.lock", 8, true)  ' Flag setzen
  If exclusion_vorhanden Then   ' falls Ausnahme fr die aktuelle Uhrzeit definiert ist
    Call logging("Rechner wird nicht " & herunterfahrentext & " gefahren wg. Ausnahme " & wochentag & " " & von & "-" & bis)
  Else
    If dateien_zu_alt(programpath & "temp") Then
      If full_logging Then Call logging("Rechner wird nicht " & herunterfahrentext & " gefahren, da TMP-Dateien zu alt (vermutlich nach manuellem Ruhezustand)")  	
    Else
      If adhocexclusion_vorhanden() Then
        Call logging("Rechner wird nicht " & herunterfahrentext & " gefahren wg. Adhoc-Ausnahme bis " & adhocexclusion)    	
      Else
        ' Temp-Dateien lschen
        fs.deletefile(programpath & "temp\*.*")
        ' gleich wieder eine neue TMP-Datei schreiben
        zufallszahl = Int(Rnd(1)*100000000)
        Set CountFile = fs.OpenTextFile(programpath & "temp\BedingterRuhezustand-" & zufallszahl & ".tmp", 8, true)  ' Datei erzeugen
        CountFile.close
        wscript.sleep 4000
        ' in den Ruhezustand fahren
        Call logging("Fahre Rechner " & herunterfahrentext & "...")
        wscript.sleep 1000
        If herunterfahren = 0 Then result = ShellWSH.Run("rundll32.exe powrprof.dll,SetSuspendState")   
        If herunterfahren = 1 Then result = ShellWSH.Run("shutdown.exe -s -f")   
      End If
    End If
  End If
End if


Function exclusion_vorhanden()
  ' Exclude-Liste Exclude.txt einlesen
  exclusion_vorhanden = 0   ' grundstzlich in Ruhezustand fahren, ausser wenn Ausnahme in Exclude.txt definiert ist
  Dim wochentage(7)
  wochentage(1) = "So"
  wochentage(2) = "Mo"
  wochentage(3) = "Di"
  wochentage(4) = "Mi"
  wochentage(5) = "Do"
  wochentage(6) = "Fr"
  wochentage(7) = "Sa"
  datum = Date 
  zeit = Time
  wochentag = wochentage(Weekday(Datum))
  Set ExcludeListe = fs.OpenTextFile(programpath & "Exclude.txt", 1, true)             					
  Do Until ExcludeListe.AtEndOfStream
    zeile = Trim(ExcludeListe.ReadLine)
    If LCase(Left(zeile,2)) = LCase(wochentag) Then   ' heutiger Tag
      If exclusion_vorhanden = 0 Then
        pos1 = InStr(zeile,"=")
        pos2 = InStr(zeile,"-")
        von = CDate(Mid(zeile,pos1+1,pos2-pos1-1))
        bis = CDate(Mid(zeile,pos2+1))
        If zeit > von and zeit < bis Then
          exclusion_vorhanden = 1
        End If
      End If
    End If
  loop
End Function


Function adhocexclusion_vorhanden()
  ' Prfen, ob die Datei AdhocExclusion.txt eine Adhoc-Ausnahme enthlt
  adhocexclusion_vorhanden = 0
  zeit = CDate(Date & " " & Time)
  Set AdhocExcludeListe = fs.OpenTextFile(programpath & "AdhocExclusion.txt", 1, true)             					
  Do Until AdhocExcludeListe.AtEndOfStream
    zeile = Trim(AdhocExcludeListe.ReadLine)
    pos1 = InStr(zeile,"=")
    adhocexclusion = CDate(Mid(zeile,pos1+1))
    'MsgBox adhocexclusion
    'MsgBox zeit
    If zeit < adhocexclusion Then
      'MsgBox "AdhocExclusion = Yes"	
      adhocexclusion_vorhanden = 1
    End If
  loop
End Function


Function dateien_zu_alt(verzeichnis)
  ' berprft, ob die Dateien im temp-Verzeichnis aktuell oder veraltet 
  ' sind. Falls sie veraltet sind, wurde vorher vom Anwender manuell 
  ' in den Ruhezustand gefahren. Dabei wird der Idle-Counter vom System
  ' nicht zurckgesetzt. In diesem Fall darf vom Skript nicht in den Ruhe-
  ' zustand gefahren werden. Falls mindestens zwei TMP-Dateien vorhanden
  ' sind, wird die zweitlteste herangezogen. Es wird dann berprft, ob 
  ' sie lter als 210 Sekunden ist. Bei nur einer Datei --> 150 Sekunden.
  Dim dateiname(2880)
  Dim dateidatum(2880)
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  Set objFolder = objFSO.GetFolder(verzeichnis)
  Set colFiles = objFolder.Files
  i = 1
  For Each objFile in colFiles
    dateiname(i) = objFile.Name
    dateidatum(i) = objFile.DateLastModified
    i = i + 1
  Next
  jetzt = Now
  'neueste Datei ermitteln
  neueste = 1
  differenz = DateDiff("s", dateidatum(neueste), jetzt)
  For j = 1 to i - 1
    If DateDiff("s", dateidatum(j), jetzt) < differenz Then
      differenz = DateDiff("s", dateidatum(j), jetzt)
      neueste = j
    End If
  Next
  DatumNeuesteDatei = dateidatum(neueste)
  Set f = objFSO.GetFolder(verzeichnis)
  Set fc = f.Files
  DatumZweitneuesteDatei = ""
  If f.files.count > 1 Then   ' falls mindestens 2 Dateien im Verzeichnis
    'zweitneueste Datei ermitteln
    zweitneueste = 1
    differenz = DateDiff("s", dateidatum(zweitneueste), jetzt)
    If neueste = 1 Then zweitneueste = 2 
    For j = 1 to i - 1
      If j <> neueste Then
        If DateDiff("s", dateidatum(j), jetzt) < differenz Then
          differenz = DateDiff("s", dateidatum(j), jetzt)
          zweitneueste = j
        End If
      End If
    Next
    DatumZweitneuesteDatei = dateidatum(zweitneueste)
  End If
  dateien_zu_alt = 0
  If DatumZweitneuesteDatei = "" Then 
    If DateDiff("s", DatumNeuesteDatei, jetzt) > 150 Then dateien_zu_alt = 1   ' Datei ist lter als 2,5 Min.
  Else
    If DateDiff("s", DatumZweitneuesteDatei, jetzt) > 210 Then dateien_zu_alt = 1   ' Datei ist lter als 3,5 Min.
  End If
End Function
  


Sub logging(logtext)
  ' Logging in Logfile BedingterRuhezustand.log
  Set LogFile = fs.OpenTextFile(programpath & "BedingterRuhezustand.log", 8, true)  
  LogFile.writeline Date & " " & Time & "   " & logtext	
  LogFile.Close			
End Sub


