' MaschinenStart.vbs 1.2 von Robert Hohmann 06/2009
' berprft, ob Rechner, die in der Datei PCListe.txt aufgelistet
' sind, auf Ping antworten. Schreibt die eingeschalteten Rechner
' in die Datei an.txt. Startet die ausgeschalteten Rechner per
' Wake-On-Lan. 


Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8
Dim PC(5000)
Dim Mac(5000)
Dim masks(100)
Public PingErgebnis
Public byte1, byte2, byte3, byte4

pos1 = InstrRev(WScript.ScriptFullName, "\")
path = Left(WScript.ScriptFullName, pos1)

Set fs = CreateObject("Scripting.FileSystemObject")
Set ShellWSH = CreateObject("Wscript.Shell")
Set LogFile = fs.OpenTextFile(path & "log\MaschinenStopp.log", 8, true)   ' allgemeines Logfile				
Set PCListe = fs.OpenTextFile(path & "PCListe.txt", 1, true)              ' Datei mit allen PCs		
Set AnLog = fs.OpenTextFile(path & "log\an.txt", 2, true)                 ' Liste der eingeschalteten Rechner
Set CfgFile = fs.OpenTextFile(path & "MaschinenStopp.cfg", 1, true)       ' Konfigurationsdatei


' MaschinenStopp.cfg einlesen
anzahl_masks = 0
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If Left(zeile,1) <> "#" Then   ' Kommentar
    If LCase(Left(zeile,10)) = "subnetmask" Then
      anzahl_masks = anzahl_masks + 1
      pos1 = InStr(zeile, "=")
      masks(anzahl_masks) = Trim(Mid(zeile,pos1+1))
    End If
    If LCase(Left(zeile,6)) = "wakeup" Then
      pos1 = InStr(zeile, "=")
      wakeup = LCase(Trim(Mid(zeile,pos1+1)))
    End If
    If LCase(Left(zeile,9)) = "pingcount" Then
      pos1 = InStr(zeile, "=")
      pingcount = LCase(Trim(Mid(zeile,pos1+1)))
    End If
    If LCase(Left(zeile,11)) = "pingtimeout" Then
      pos1 = InStr(zeile, "=")
      pingtimeout = LCase(Trim(Mid(zeile,pos1+1)))
    End If
  End If
loop


' PCs einlesen in das Array PC()
anzahl_pc = 0
Do Until PCListe.AtEndOfStream
  zeile = Trim(PCListe.ReadLine)
  If Len(zeile) > 10 and Left(zeile,1) <> "#" Then 
      anzahl_pc = anzahl_pc + 1
    ' PC-Name rausfiltern
    leerzeichen = Instr(1, zeile, " ")
    tabulator = Instr(1, zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      PC(anzahl_pc) = Left(zeile,trennung - 1)
    End If

    ' Mac-Adresse rausfiltern
    leerzeichen = InStrRev(zeile, " ")
    tabulator = InStrRev(zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      Mac(anzahl_pc) = Right(zeile,Len(zeile) - trennung)
    End If

  End If
loop


Call logging("======================================")

' PCs wecken
For i = 1 to anzahl_pc								
  If PingOK(PC(i)) Then								
    an = 1
    Call logging(PC(i) &" ist an.")   ' PC ist eingeschaltet, wecken nicht notwendig						
    AnLog.writeline PC(i)
  Else
    an = 0									
    If wakeup = "yes" Then 
      Call logging(PC(i) & " ist aus und wird mit Mac-Adresse " & Mac(i) & " gestartet...")					
      result = ShellWSH.Run(path & "wol.exe " & Mac(i), 0 ,True)   'PC einschalten im eigenen Subnetz
      ' IP-Adresse bestimmen (steht in temp.txt in eckigen Klammern und muss Punkte enthalten)
      pos1 = InStr(PingErgebnis, "[")
      pos2 = InStr(PingErgebnis, "]")
      If pos1 < pos2 Then temp = Mid(PingErgebnis, pos1+1, pos2-pos1-1)
      If pos1 < pos2 and InStr(temp, ".") > 1 Then 
        ip = temp
      Else
        ip = "keine IP"  
      End If 
      If ip <> "keine IP" Then
        ' Fr jede Subnetzmaske die Broadcastadresse bestimmen
        For j = 1 to anzahl_masks
          x = GetBytes(masks(j))
          maskbyte1 = byte1 xor 255
          maskbyte2 = byte2 xor 255
          maskbyte3 = byte3 xor 255
          maskbyte4 = byte4 xor 255
          x = GetBytes(ip)
          broadcastbyte1 = byte1 or maskbyte1
          broadcastbyte2 = byte2 or maskbyte2
          broadcastbyte3 = byte3 or maskbyte3
          broadcastbyte4 = byte4 or maskbyte4
          broadcast = broadcastbyte1 & "." & broadcastbyte2 & "." & broadcastbyte3 & "." & broadcastbyte4
          Call logging("...zusaetzlicher Weckversuch mit IP-Broadcast " & broadcast)					
          result = ShellWSH.Run(path & "wol.exe " & Mac(i) & " " & broadcast, 0 ,True)	'PC einschalten im fremden Subnetz	
        Next
      End If
    Else   ' wakeup = "no"
      Call logging(PC(i) & " wird nicht geweckt wg. globaler Einstellung Wakeup=no")					
    End If 
  End if
Next



Sub logging(logtext)
  ' Logging in allgemeines Logfile MaschinenStopp.log
  LogFile.writeline Date & " " & Time & "   " & logtext				
End Sub


Function PingOK(rechner)
  ' Prft per Standard-Ping, ob der bergebene Rechner eingeschaltet ist
  Pingtest = "%comspec% /c ping.exe -4 -n " & pingcount & " -w " & pingtimeout & " -a" & " " & rechner & " " & ">" & path & "temp.txt"   ' PC anpingen, Ergebnis in temp.txt schreiben	
  result = ShellWSH.Run(Pingtest,0,True) 
  Set TempFile = fs.OpenTextFile(path & "temp.txt")       
  PingErgebnis = Tempfile.Readall   ' Alles aus Tempfile in Variable PingErgebnis einlesen
  If instr(PingErgebnis, "ytes=") > 0 Then   ' PC ist an	
    PingOK = 1
  Else   ' PC ist aus
    PingOK = 0
  End If
End Function


Function GetBytes(my_ip)
  ' Zerlegt IP-Adress-String in einzelne Bytes
  my_ip = Trim(my_ip)
  pos1 = InStr(my_ip, ".")
  pos3 = InStrRev(my_ip, ".")
  temp = Left(my_ip, pos3-1)
  pos2 = InStrRev(temp, ".")
  byte1 = Left(my_ip, pos1-1)
  byte2 = Mid(my_ip, pos1+1, pos2-pos1-1)
  byte3 = Mid(my_ip, pos2+1, pos3-pos2-1)
  byte4 = Mid(my_ip, pos3+1)  
End Function