' ZustandVorher.vbs 1.2 von Robert Hohmann 06/2009
' berprft, ob Rechner, die in der Datei PCListe.txt aufgelistet
' sind, auf Ping antworten. Schreibt die Logdatei vorher.log. 


Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8
Dim PC(5000)
Dim Mac(5000)

pos1 = InstrRev(WScript.ScriptFullName, "\")
path = Left(WScript.ScriptFullName, pos1)

Set fs = CreateObject("Scripting.FileSystemObject")
Set ShellWSH = CreateObject("Wscript.Shell")
Set LogFile = fs.OpenTextFile(path & "log\MaschinenStopp.log", 8, true)  ' allgemeines Logfile
Set AnAusLog = fs.OpenTextFile(path & "log\vorher.log", 8, true)         ' Logfile fr Vorher-Zustand
Set PCListe = fs.OpenTextFile(path & "PCListe.txt", 1, true)             ' Datei mit allen PCs					
Set CfgFile = fs.OpenTextFile(path & "MaschinenStopp.cfg", 1, true)      ' Konfigurationsdatei


' MaschinenStopp.cfg einlesen
anzahl_masks = 0
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If Left(zeile,1) <> "#" Then   ' Kommentar
    If LCase(Left(zeile,9)) = "pingcount" Then
      pos1 = InStr(zeile, "=")
      pingcount = LCase(Trim(Mid(zeile,pos1+1)))
    End If
    If LCase(Left(zeile,11)) = "pingtimeout" Then
      pos1 = InStr(zeile, "=")
      pingtimeout = LCase(Trim(Mid(zeile,pos1+1)))
    End If
  End If
loop


' PCs einlesen in das Array PC()
anzahl_pc = 0
Do Until PCListe.AtEndOfStream
  zeile = Trim(PCListe.ReadLine)
  If Len(zeile) > 10 and Left(zeile,1) <> "#" Then 
    anzahl_pc = anzahl_pc + 1
    ' PC-Name rausfiltern
    leerzeichen = Instr(1, zeile, " ")
    tabulator = Instr(1, zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      PC(anzahl_pc) = Left(zeile,trennung - 1)
    End If

    ' Mac-Adresse rausfiltern
    leerzeichen = InStrRev(zeile, " ")
    tabulator = InStrRev(zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      Mac(anzahl_pc) = Right(zeile,Len(zeile) - trennung)
    End If
  End If
loop

AnAusLog.writeline("======================================")

' Zustand der PCs berprfen (an/aus)
an = 0
aus = 0
For i = 1 to anzahl_pc						
  If PC(i) <> PC(i-1) Then   ' Dubletten nur 1x pingen
    If PingOK(PC(i)) Then   ' PC ist an	
      AnAusLog.writeline Date & " " & Time & "   " & PC(i) & " ist an."
      an = an + 1
    Else   ' PC ist aus
      AnAusLog.writeline Date & " " & Time & "   " & PC(i) & " ist ausgeschaltet."
      aus = aus + 1
    End if	
  End If
Next


AnAusLog.writeline("--------------------------------------")
AnAusLog.writeline Date & " " & Time & "   " & an & " PC(s) eingeschaltet, " & aus & " PC(s) ausgeschaltet."


Sub logging(logtext)
  ' Logging in allgemeines Logfile MaschinenStopp.log
  LogFile.writeline Date & " " & Time & "   " & logtext				
End Sub


Function PingOK(rechner)
  ' Prft per Standard-Ping, ob der bergebene Rechner eingeschaltet ist
  Pingtest = "%comspec% /c ping.exe -4 -n " & pingcount & " -w " & pingtimeout & " -a" & " " & rechner & " " & ">" & path & "temp.txt"   ' PC anpingen, Ergebnis in temp.txt schreiben	
  result = ShellWSH.Run(Pingtest,0,True) 
  Set TempFile = fs.OpenTextFile(path & "temp.txt")       
  PingErgebnis = Tempfile.Readall   ' Alles aus Tempfile in Variable PingErgebnis einlesen
  If instr(PingErgebnis, "ytes=") > 0 Then   ' PC ist an	
    PingOK = 1
  Else   ' PC ist aus
    PingOK = 0
  End If
End Function
