' Setup.vbs fr MaschinenStopp 1.2
' von Robert Hohmann 06/2009

On Error Resume Next

Set Reg = GetObject("winmgmts:root\Default:StdRegProv")
Set Shell = CreateObject("Wscript.Shell")
Set fs = CreateObject("Scripting.FileSystemObject")
Set Env = Shell.Environment("Process")
Set oDrives = fs.Drives
pos1 = InstrRev(WScript.ScriptFullName, "\")
setuppath = Left(WScript.ScriptFullName, pos1)
Set LogFile = fs.OpenTextFile(setuppath & "\installation.log", 8, true)


Const HKEY_LOCAL_MACHINE = &H80000002


Call logging("===============================================")
Call logging("MaschinenStopp-Installation wird gestartet...")

'***************************************************************************************************************************
' Get install path
'***************************************************************************************************************************
Do
  path = inputbox("Schritt 1 von 6:" & Chr(13) & Chr(13) & "Bitte geben Sie den Installationspfad an:","MaschinenStopp Installation","C:\MaschinenStopp")
  check = true
  If path = "" Then
    MsgBox "Installation durch Anwender abgebrochen."
    Call logging("Installation durch Anwender abgebrochen.")
    WScript.Quit	
  End if
  If fs.FolderExists(path) Then
    MsgBox "Pfad existiert bereits."
    check = false
  End If	
  If InStr(path," ") Then 
    MsgBox "Bitte Pfad ohne Leerzeichen angeben!"
    check = false
  End If
  If Len(path) < 4 Then 
    MsgBox "Ungltiger Pfad."
    check = false
  End If
loop until check = true

Call logging("Installationspfad ist " & path)


result = fs.CreateFolder(path)
If err.number = 0 then
    Call logging("Erstellung von Verzeichnis " & path & " erfolgreich.")        	
Else
    Call logging("Erstellung von Verzeichnis " & path & " fehlgeschlagen.")        	
    MsgBox "Erstellung von Verzeichnis " & path & " fehlgeschlagen."      	        
    Call logging("Sie bentigen Administratorrechte fr diese Installation.")        	
    call cleanup
    WScript.Quit
End if
result = fs.CreateFolder(path & "\Log")
If err.number = 0 then
    Call logging("Erstellung von Verzeichnis " & path & "\Log" & " erfolgreich.")        	
Else
    Call logging("Erstellung von Verzeichnis " & path & "\Log" & " fehlgeschlagen.")        	
    MsgBox "Erstellung von Verzeichnis " & path & "\Log" & " fehlgeschlagen."      	        
    Call logging("Sie bentigen Administratorrechte fr diese Installation.")        	
    call cleanup
    WScript.Quit
End if


'***************************************************************************************************************************
' Copy Files
'***************************************************************************************************************************
If not fs.FileExists(setuppath & "\ZustandVorher.vbs") Then 
    Call logging("ZustandVorher.vbs fehlt!")
    MsgBox "ZustandVorher.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\ZustandNachher.vbs") Then 
    Call logging("ZustandNachher.vbs fehlt!")
    MsgBox "ZustandNachher.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\MaschinenStopp.vbs") Then 
    Call logging("MaschinenStopp.vbs fehlt!")
    MsgBox "MaschinenStopp.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\MaschinenStart.vbs") Then 
    Call logging("MaschinenStart.vbs fehlt!")
    MsgBox "MaschinenStart.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\CancelShutdown.vbs") Then 
    Call logging("CancelShutdown.vbs fehlt!")
    MsgBox "CancelShutdown.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\MaschinenStopp.cfg") Then 
    Call logging("MaschinenStopp.cfg fehlt!")
    MsgBox "MaschinenStopp.cfg fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\Include.txt") Then 
    Call logging("Include.txt fehlt!")
    MsgBox "Include.txt fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\Exclude.txt") Then 
    Call logging("Exclude.txt fehlt!")
    MsgBox "Exclude.txt fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\PCListe.txt") Then 
    Call logging("PCListe.txt fehlt!")
    MsgBox "PCListe.txt fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\wol.exe") Then 
    Call logging("wol.exe fehlt!")
    MsgBox "wol.exe fehlt!"
    abort = 1
End If

If abort > 0 Then 
    MsgBox "Installation abgebrochen! Bitte klicken Sie auf OK fr die Installations-Logdatei."
    If abort = 1 Then Call cleanup
    result = shell.Run("cmd.exe /c notepad.exe " & setuppath & "\installation.log", 0, False)
    WScript.Quit
End If

fs.CopyFile setuppath & "\ZustandVorher.vbs", path & "\ZustandVorher.vbs"
fs.CopyFile setuppath & "\ZustandNachher.vbs", path & "\ZustandNachher.vbs"
fs.CopyFile setuppath & "\MaschinenStopp.vbs", path & "\MaschinenStopp.vbs"
fs.CopyFile setuppath & "\MaschinenStart.vbs", path & "\MaschinenStart.vbs"
fs.CopyFile setuppath & "\CancelShutdown.vbs", path & "\CancelShutdown.vbs"
fs.CopyFile setuppath & "\MaschinenStopp.cfg", path & "\MaschinenStopp.cfg"
fs.CopyFile setuppath & "\Include.txt", path & "\Include.txt"
fs.CopyFile setuppath & "\Exclude.txt", path & "\Exclude.txt"
fs.CopyFile setuppath & "\PCListe.txt", path & "\PCListe.txt"
fs.CopyFile setuppath & "\wol.exe", path & "\wol.exe"

wscript.Sleep 2000

Call logging("Dateien erfolgreich kopiert.")
MsgBox "Dateien erfolgreich kopiert." & Chr(13) & Chr(13) & "Klicken Sie auf OK zur Erstellung der geplanten Tasks..."

wscript.Sleep 1000


'***************************************************************************************************************************
' Install Scheduled Tasks
'***************************************************************************************************************************
' Language detection
strComputer = "."
Set objWMIService = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\.\root\cimv2")

Set colOperatingSystems = objWMIService.ExecQuery _
    ("Select * from Win32_OperatingSystem")

For Each objOperatingSystem in colOperatingSystems
    If objOperatingSystem.OSLanguage = 1031 Then sprache = "deutsch"
    If objOperatingSystem.OSLanguage = 1033 Then sprache = "englisch"
Next

If sprache = "deutsch" Then 
  intervall = "WCHENTLICH"
  tag1 = "DI"
  tag2 = "MI"
End If
If sprache = "englisch" Then 
  intervall = "WEEKLY"
  tag1 = "TUE"
  tag2 = "WED"
End If
Call logging("Betriebssystemsprache ist " & sprache)


konto = inputbox("Schritt 2 von 6:" & Chr(13) & Chr(13) & "Sie bentigen ein Benutzerkonto, unter dessen Kontext die geplanten Tasks ausgefhrt werden. Dabei kann es sich um ein lokales oder ein Domnenkonto handeln. Das Konto muss Administrationsrechte auf allen zu weckenden PCs besitzen." & Chr(13) & Chr(13) & "Beispiel: Domain\Administrator" & Chr(13) & Chr(13) & "Vista/Server 2008: Bitte Konto des aktuell angemeldeten Benutzers eingeben." & Chr(13) & Chr(13) & "Bitte geben Sie das Benutzerkonto an:")
If konto = "" Then
  MsgBox "Installation durch Anwender abgebrochen."
  Call logging("Installation durch Anwender abgebrochen.")
  Call cleanup
  WScript.Quit
End If
Call logging("Benutzerkonto ist " & konto)
wscript.Sleep 1000

MsgBox "Schritt 3 von 6:" & Chr(13) & Chr(13) & "Der erste geplante Task (ZustandVorher) wird jetzt erstellt. Sie werden whrend" & Chr(13) & "der Installation aufgefordert, das Kennwort fr das von Ihnen angegebene" & Chr(13) & "Benutzerkonto einzugeben (nur unter XP/Server 2003)."
task = "SCHTASKS /Create /RU " & konto & " /SC " & intervall & " /D " & tag1 & " /ST 22:00:00 /TN ZustandVorher /TR " & Chr(34) & "wscript.exe " & path & "\ZustandVorher.vbs" & Chr(34)
result = shell.Run(task, 1, True)
Call logging("Taskerstellung mit: " & task)
If result <> 0 Then
  MsgBox "Fehler bei der Erstellung des Geplanten Tasks."
  Call logging("Fehler bei der Erstellung des Geplanten Tasks.")
  Call cleanup
  WScript.Quit  
End if 
wscript.Sleep 1000

MsgBox "Schritt 4 von 6:" & Chr(13) & Chr(13) & "Der zweite geplante Task (MaschinenStart) wird jetzt erstellt. Sie werden whrend" & Chr(13) & "der Installation aufgefordert, das Kennwort fr das von Ihnen angegebene" & Chr(13) & "Benutzerkonto einzugeben (nur unter XP/Server 2003)."
task = "SCHTASKS /Create /RU " & konto & " /SC " & intervall & " /D " & tag1 & " /ST 22:30:00 /TN MaschinenStart /TR " & Chr(34) & "wscript.exe " & path & "\MaschinenStart.vbs" & Chr(34)
result = shell.Run(task, 1, True)
Call logging("Taskerstellung mit: " & task)
If result <> 0 Then
  MsgBox "Fehler bei der Erstellung des Geplanten Tasks."
  Call logging("Fehler bei der Erstellung des Geplanten Tasks.")
  Call cleanup
  WScript.Quit  
End if 
wscript.Sleep 1000

MsgBox "Schritt 5 von 6:" & Chr(13) & Chr(13) & "Der dritte geplante Task (ZustandNachher) wird jetzt erstellt. Sie werden whrend" & Chr(13) & "der Installation aufgefordert, das Kennwort fr das von Ihnen angegebene" & Chr(13) & "Benutzerkonto einzugeben (nur unter XP/Server 2003)."
task = "SCHTASKS /Create /RU " & konto & " /SC " & intervall & " /D " & tag1 & " /ST 23:00:00 /TN ZustandNachher /TR " & Chr(34) & "wscript.exe " & path & "\ZustandNachher.vbs" & Chr(34)
result = shell.Run(task, 1, True)
Call logging("Taskerstellung mit: " & task)
If result <> 0 Then
  MsgBox "Fehler bei der Erstellung des Geplanten Tasks."
  Call logging("Fehler bei der Erstellung des Geplanten Tasks.")
  Call cleanup
  WScript.Quit  
End if 
wscript.Sleep 1000

MsgBox "Schritt 6 von 6:" & Chr(13) & Chr(13) & "Der vierte geplante Task (MaschinenStopp) wird jetzt erstellt. Sie werden whrend" & Chr(13) & "der Installation aufgefordert, das Kennwort fr das von Ihnen angegebene" & Chr(13) & "Benutzerkonto einzugeben (nur unter XP/Server 2003)."
task = "SCHTASKS /Create /RU " & konto & " /SC " & intervall & " /D " & tag2 & " /ST 03:00:00 /TN MaschinenStopp /TR " & Chr(34) & "wscript.exe " & path & "\MaschinenStopp.vbs" & Chr(34)
result = shell.Run(task, 1, True)
Call logging("Taskerstellung mit: " & task)
If result <> 0 Then
  MsgBox "Fehler bei der Erstellung des Geplanten Tasks."
  Call logging("Fehler bei der Erstellung des Geplanten Tasks.")
  Call cleanup
  WScript.Quit  
End if 
wscript.Sleep 1000


'***************************************************************************************************************************
' Complete Installation
'***************************************************************************************************************************
Call logging("MaschinenStopp-Installation erfolgreich.")
MsgBox "MaschinenStopp-Installation erfolgreich." & Chr(13) & Chr(13) & "Bitte klicken Sie auf OK, um die nchsten Schritte anzuzeigen." 

result = shell.Run("cmd.exe /c notepad.exe " & setuppath & "\NextSteps.txt", 0, False)



Sub logging(logtext)
    LogFile.writeline Date & " " & Time & "   " & logtext
End Sub

Sub cleanup
    LogFile.Close
    Set fs = CreateObject("Scripting.FileSystemObject")
    result = fs.DeleteFolder(path)
End Sub

