// GCC 4.5 can not do this yet.
#include <iostream>
#include <cstdlib>
using namespace std;

struct Frac {
	int z, n;
	Frac(int v) : z(v),n(1) {}
	Frac(int z_, int n_) : z(z_),n(n_) { }
	void mul(const Frac &o) { z*=o.z; n*=o.n; }
	double val() const { return (double)z/(double)n; }
};

struct Smart1 : public Frac {
	void simplify() { if(z%n==0) z/=n;n=1; }  
};
struct Smart2 : public Frac {
	using Frac::Frac;
	void simplify() { if(z%n==0) z/=n;n=1; }  
};


int main() {
	std::cerr << "=== " << __FILE__ << " ===" << std::endl;

	// not in Smart1, will not compile.
	//Smart1 x(3,5);

	Smart2 x(3,5);

	return EXIT_SUCCESS;
}
