// sequence constructor demo

#include <vector>
#include <iostream>
#include <initializer_list> //! include needed

//////////////////////////////////////////////////////////////////////

class SomeInts {
private:
  typedef std::vector<int>::const_iterator iter_t;
public:
  SomeInts(std::initializer_list<int> list);  //!=b init list c'tor #1
  // implement simplest iterator
  iter_t begin() const { return cont_.begin(); }
  iter_t end() const { return cont_.end(); }
private:
  std::vector<int> cont_;
private:
  explicit SomeInts();                  // no impl, no implicit construction
  SomeInts(const SomeInts&);            // no impl, no copy
  SomeInts& operator=(const SomeInts&); // no impl, no assign
};

struct MyVec {
  int *a; int s;
  MyVec(std::initializer_list<int> seq)
    : a{new int[seq.size()]}, s{seq.size()}
  { std::copy(seq.begin(), seq.end(), a); }
  ~MyVec() { delete[] a; }
};

SomeInts::SomeInts(std::initializer_list<int> list)
  : cont_()
{
  cont_.assign(list.begin(), list.end());
}

//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  
  std::cerr << "The int-vector from int-list:";
  SomeInts vec1 { 1001, 2022, 3333 }; //!=b call init list c'tor #1
  for(auto it = vec1.begin(); it != vec1.end(); ++it) { //! auto typed variable
    std::cerr << "  " << *it;
  }
  std::cerr << std::endl;

  std::cerr << "The int-array from int-list:";
  MyVec vec2 = { 1,2,3,4,5,6,7 };
  for(auto it = vec2.a; it != vec2.a+vec2.s; ++it) {
    std::cerr << "  " << *it;
  }
  std::cerr << std::endl;
    
  return EXIT_SUCCESS;
}

//- eof
