// initializer list template function demo

#include <iostream>
#include <initializer_list> //! include for init'er list
#include <algorithm>        // copy
#include <iterator>         // ostream_iterator
#include <typeinfo>         // typeid, only available if compiled with RTTI //=b

//////////////////////////////////////////////////////////////////////

template<typename TYPE>
void dump_any(std::initializer_list<TYPE> list) //!=b free function with init'er list template
{
  std::ostream_iterator<TYPE> oit(std::cout, " "); // 'operator<<' must be defined for 'TYPE'
  std::copy(list.begin(), list.end(), oit);
  std::cout << " of type:" << typeid(TYPE).name() << std::endl; // show us the template type //=b
}

//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  dump_any( { 2,3,5,7,13,17 } );       //!=b template inst'ion with ints
  dump_any( { 1.01, 2.718, 3.141, } ); //!=b template inst'ion with doubles. Trailing ',' now allowed.

  return EXIT_SUCCESS;
}

//- eof
