// initializer list return value demo
#include <iostream>
#include <initializer_list> //! include for init'er list
#include <iterator>         // ostream_iterator
#include <typeinfo>         // typeid, only available if compiled with RTTI //=b

//////////////////////////////////////////////////////////////////////

static
void dump_ints(const std::string &name,         //=b
	       std::initializer_list<int> list) //! free function with init'er list
{
  std::cerr << "  " << name << ": ";
  std::ostream_iterator<int> oit(std::cerr, " "); // copies elements to cerr
  std::copy(list.begin(), list.end(), oit);       // init'er list behaves like std container
  std::cerr << std::endl;
}

static int sq(int n) { return n*n; } //=b a helper function

static
std::initializer_list<int> make_ints(int what) //!=b return init'er list
{                                     //=b
  switch(what) {                      //=b
  case 0: return { 1,2,3 };           //!=b init'er list return value
  case 1: return { sq(10), sq(11) };  //!=b init'er list with functions, CURRENTLY WRONG!
  default: return { };                //!=b empty list
  }                                   //=b
}                                     //=b

//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  
  dump_ints("+1",make_ints(0) ); //!=b print returned list, literals
  dump_ints("`2",make_ints(1) ); //!=b print returned list, functions; CURRENTLY WRONG!
  dump_ints("em",make_ints(9) ); //!=b prints the empty list

  int a[6] = {3,1,4,1,5,2};      // usual C initialization         //=b
  std::cerr <<"  pi: "                                             //=b
	    <<a[0]<<'.'<<a[1]<<a[2]<<a[3]<<a[4]<<a[5]<< std::endl; //=b

  int b[6] {2,7,1,8,2,8};        //!=b for newstyle init'er list = is optional
  std::cerr <<"   e: "                                             //=b
	    <<b[0]<<'.'<<b[1]<<b[2]<<b[3]<<b[4]<<b[5]<< std::endl; //=b

  /* not yet in gcc-4.4.0:
  class IntVec { // local class
    int d[4];
  public:
    IntVec() : d{1,4,9,16} {} //!=b init array member; ERROR in gcc-4.4.0
    void dump() const { dump_ints("mb",{d[0],d[1],d[2],d[3]} ); }
  };
  IntVec ivec{};
  ivec.dump();
  */
  return EXIT_SUCCESS;
}

//- eof
