// fractional datatype demo, rvalue references
#include <string>
#include <iostream>

static void note(const std::string& msg) { std::cerr << "  " << msg << std::endl; }

class Frac {
private:
  int zahl_;
  int nenn_;
public:
  // usual con- and destruct and assign
  Frac() : zahl_(0), nenn_(1) { note("DFLT"); } // '0/1'
  ~Frac() { /* note("  ~dtr"); */ }
  Frac(const Frac &o) : zahl_(o.zahl_), nenn_(o.nenn_) { note("COPY"); }
  Frac& operator=(const Frac& o) 
  { zahl_=o.zahl_; nenn_=o.nenn_; note("ASSN"); return *this; }
  //!=b construction from temps, implementing move semantics
  Frac(Frac &&o) : zahl_(o.zahl_), nenn_(o.nenn_) { note("MOVE"); } //!=b move c'tor
  Frac& operator=(Frac &&o)                                         //!=b move op
  { zahl_=o.zahl_; nenn_=o.nenn_; note("MOV="); return *this; }
  // construct from an int. explicit prevents accidental conversion
  explicit Frac(int eintel) : zahl_(eintel), nenn_(1) { note("1TEL"); }
  // natural way to construct a Fractional by providing its numbers
  Frac(int zahl, int nenn) : zahl_(zahl), nenn_(nenn) { note("FRAC"); }
  // interface to the non-fractional world
  operator double() const { return (double)z()/n(); }
public:
  int z() const { return zahl_; }
  int n() const { return nenn_; }
  // assign-ops -- very useful, no temporaries needed
  Frac& operator*=(const Frac &o)
  { zahl_*=o.zahl_; nenn_*=o.nenn_; return *this; } 
  Frac& operator+=(const Frac &o)
  { int x=n()*o.n(); zahl_=z()*o.n()+o.z()*n(); nenn_=x; return *this; }
};

// output
std::ostream& operator<<(std::ostream &os, const Frac& f) {
  return os << "{" << f.z() << "/" << f.n() << "}";
}

// arithmetics
Frac operator*(const Frac a, const Frac &b) {
  return Frac(a.z()*b.z(), a.n()*b.n());
}
Frac& operator*(Frac &&a, const Frac &b) {    //!=b a is an rvalue
  return a *= b; // use a for result           //=b
}
Frac& operator*(const Frac &a, Frac &&b) {    //!=b b is an rvalue
  return b *= a; // use b for result           //=b
}
Frac& operator*(Frac &&a, Frac &&b) {         //!=b both args are rvalues
  return a *= b; // use any arg for result     //=b
}

Frac operator+(const Frac &a, const Frac &b) {
  return Frac(a.z()*b.n() + b.z()*a.n(), a.n()*b.n());
}
Frac& operator+(Frac &&a, const Frac &b) {    //!=b a is an rvalue
  return a += b;  // use a for result          //=b
}
Frac& operator+(const Frac &a, Frac &&b) {    //!=b b is an rvalue
  return b += a;  // use b for result          //=b
}
Frac& operator+(Frac &&a, Frac &&b) {         //!=b both args are rvalues
  return a += b;  // use any arg for result    //=b
}


//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  Frac pi(22, 7);
  std::cerr << "pi: " << pi << " = " << (double)pi << std::endl;

  Frac a(3,8);  
  std::cerr << "calculation with temporaries..." << std::endl;
  Frac b = a * Frac(2) + Frac(4) * Frac(5,4); // calculation with many temps
  std::cerr << "3/8 * 2 + 4 * 5/4: " << b << " = " << (double)b << std::endl;
  // alternative, if we implepented ops with int args too:
  //Frac b = a * 2 + 4 * Frac(5,4);

  return EXIT_SUCCESS;
}
//- eof
