// order of + and * avealuation check
#include <iostream>
#include <cstdlib>
using namespace std;

struct BigOld {
  int i;
  explicit BigOld(int i) : i(i) {}
  // convenient ops:
  explicit BigOld(); //no defaulting
#ifdef __GXX_EXPERIMENTAL_CXX0X__
  // move ops:
  BigOld(BigOld&&o) : i(o.i) { cerr << "  move" << endl; } // = delete;
  BigOld& operator=(BigOld&&o) {i=o.i; cerr << "  mv-assn" << endl; return *this; }  //= delete;
private:
#endif
  // copy ops:
  BigOld(const BigOld&o) :i(o.i) { cerr << "  copy" << endl; }
  BigOld& operator=(const BigOld&o) { i=o.i; cerr << "  assign" << endl; return *this; }
};


BigOld make_big_old_thing(int i) {
  // prevent compiler to prepare a place for returned object outside function
  BigOld ver1(i/2);
  BigOld ver2(i*3+1);
  if(i%2==0) return ver1;
  return ver2;
}

int main() {
  cerr << "=== " << __FILE__ << " ===" << endl;

  cerr << "-- call make_big_old_thing(66)" << endl;
  BigOld bo66 = make_big_old_thing(66);
  cerr << bo66.i << endl;
 
  return EXIT_SUCCESS;
}
//- eof
