// a small demo object used for bulk creation
#include <iostream>  // cerr

struct Number { // easy convertable from and to int
  int val;
  Number() : val(0) { ++g_constr; }
  Number(int value) : val(value) { ++g_constr; }
  Number(const Number& n) : val(n.val) { ++g_constr; } 
  ~Number() { ++g_destr; }
  operator int() const { return val; }
  static int g_constr; // counts number of constructed objects
  static int g_destr;  // counts number of destroyed objects
  static void stats(std::ostream& os) { 
    os << "    Numbers: +"<<g_constr<< "-"<<g_destr<<"="<<(g_constr-g_destr)
       <<std::endl;
  }
};
int Number::g_constr = 0;
int Number::g_destr = 0;

struct Quadrate { // generator functor for square numbers
  int idx;
  Quadrate() : idx(1) { }
  Number operator()() { Number n(idx*idx); ++idx; return n; }
};

//-eof
