// check wether (basic) constexpr is available
#include <iostream>
using namespace std;

constexpr int amax(int a, int b)   //! compiles with gcc 4.5.0
{ return a>b ? a : b; }

constexpr int fib(int n)           //! compiles with gcc 4.5.0
{ return n<=1 ? 1 : fib(n-1)+fib(n-2); } 

struct Point {
  int x, y;
  constexpr Point(int a, int b) : x(a),y(b) {}  //! compiles with gcc 4.5.0
};
static constexpr Point origin(0,0); //! compiles with gcc 4.5.0

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  int normal_test[4] = {0};
  normal_test[4] = 44;
  cerr << "  normal 44?" << normal_test[4] << endl;

  int amax_test[amax(3,4)] = {0}; //! for GCC 4.5.0 this is still var-sized, thus error
  amax_test[amax(3,4)] = 55;
  cerr << "  amax 55?" << amax_test[4] << endl;
  
  int fib_test[fib(8)] = {0};   //! for GCC 4.5.0 this is still var-sized, thus error
  fib_test[fib(8)] = 66;
  cerr << "  fib 66?" << fib_test[21] << endl;

  cerr << "  origin.x:" << origin.x;  //! ok for gcc 4.5.0

  return EXIT_SUCCESS;
}
