#!/usr/bin/env python
"""reads source code, intended for C++ code, and emits it formatted. 
Some special highlighting is done using special tags. This is not
a pretty printer and therefor does parse the code.

supported format annotations:
  //=...  general formatting annotation, stripped after formatting, should be near line end.
  //=b    line contains a change to the previous version. currently formatted bold
  //!     line important, reason for the example, followed by an explanatory comment, not stripped of line. In my special case 'line contains C++0x feature'.
  //-     omit line in output. has precedence.
  //!=b   abbreviation for '//! ... //=b'
"""
from sys import *

def format(f):
    print "<pre>"
    mode = 1
    for line in f:
        l1 = line.strip('\n').replace('<','&lt;')
        # omit line
        if l1.find('//-') >= 0:
            continue
        # exclusion
        l2 = l1.replace('//<...', '//')
        if len(l2) != len(l1):
            l1 = l2
            mode = 0
        l2 = l1.replace('//>...', '//...')
        if len(l2) != len(l1):
            l1 = l2
            mode = 1
        if mode == 0:
            continue;
        # abbreviation
        l2 = l1.replace('//!=b', '//!')
        if len(l2) != len(l1):
            l2 = "%s//=b" % l2
        # important change, bold
        l1 = l2.replace('//=b', '')
        if len(l1) != len(l2):
            l1 = "<b>%s</b>" % l1
        # this is the example about.
        l2 = l1.replace('//!', '<em>//!')
        if len(l1) != len(l2):
            l2 = "<i>%s</em></i>" % l2
        # normal comments
        l1 = l2.replace('// ', '<em>// ')
        if len(l1) != len(l2):
            l1 = "%s</em>" % l1
        #
        print l1
    print "</pre>"


def main(filenames):
    print "<html><head><style type='text/css'>"
    print " body { font-size:10pt; }"
    print " pre { background:#eee; font-size:9pt; }"
    print " pre b { color:#808; font-weight:bold; }"
    print " pre i { color:#080; }"
    print " pre em { font-family:Arial,Helvetica,sans-serif; }"
    print " pre span.s { font-family:Arial,Helvetica,sans-serif; }"
    print " div.footer { font-size:smaller; color:#888; width:100%; text-align:right; }"
    print "</style></head><body>"
    if len(argv) > 1:
        for fn in argv[1:]:
            print "<h1>%s</h1>" % fn
            format(open(fn))
            print "<hr/>"
    else:
        format(stdin)
    print "<div class='footer'>autogenerated from src by <tt>src-format.py</tt>, (c) 2009 Torsten T. Will</div>"
    print "</body></html>"
    

if __name__ == "__main__":
    main(argv[1:])


    
