<#
.SYNOPSIS
Benennt Dateien und Ordner um, indem ihren Namen ein Prefix vorangestellt wird.

.DESCRIPTION
Dieses Skript benennt Dateien und Ordner um, indem es ihren Namen einen Prefix voranstellt.

.EXAMPLE
C:\PS> Add-Prefix Backup *.doc
Mit diesem Befehl bekommen alle .doc-Dateien im aktuellen Verzeichnis "Backup" vorangestellt.

.EXAMPLE
C:\PS> Add-Prefix "Kreta 2009 " .\Kamera *.jpg -Recurse
Mit diesem Befehl bekommen alle .jpg-Dateien im Unterordner Kamera des aktuellen Ordners und dessen Unterordner den
Prefix "Kreta 2009 " vorangestellt. Beachten Sie die Schreibweise: Prefixe, die Leerzeichen enthalten oder damit
enden, mssen in Anfhrungszeichen eingeschlossen werden.

.LINK
Get-ChildItem
Rename-Item

.NOTES
Copyright  2010 Heise Zeitschriften Verlag, c't
Geschrieben von Hajo Schulz (hos@ct.de)
#>
Param(
    [parameter(Mandatory=$true, Position=0)]
    [String]
    # Bestimmt die Zeichenkette, die den Namen der angegebenen Elemente vorangestellt werden soll.
    $Prefix,

    [parameter(Position=1)]
    [String[]]
    # Gibt einen Pfad zu einem oder mehreren Speicherorten an. Platzhalter sind zulssig. Der Standardspeicherort ist das aktuelle Verzeichnis (.).
    $Path,

    [parameter(Position=2)]
    [String]
    # Gibt einen Filter an, der den Path-Parameter qualifiziert.
    $Filter,
    
    [switch]
    # Fhrt die Umbenennungen an den angegebenen Speicherorten und allen untergeordneten Elementen der Speicherorte durch.
    $Recurse,
    
    [switch]
    # Beschreibt die Auswirkungen einer Ausfhrung des Befehls, ohne den Befehl tatschlich auszufhren.
    $WhatIf
)

if(!$Path) {
    $Path = (Get-Location).Path
}

$dirCmd = "Get-ChildItem -Path "
$dirCmd += "'" + ($Path -join "', '") + "'"
if($Filter) {
    $dirCmd += " -Filter '$Filter'"
}
if($Recurse) {
    $dirCmd += " -Recurse"
}

$entries = Invoke-Expression $dirCmd

foreach($entry in $entries) {
    if($WhatIf) {
        '"{0}" -> "{1}"' -f $entry.FullName, ($Prefix + $entry.Name)
    }
    else {
        Rename-Item -Path $entry.FullName -NewName ($Prefix + $entry.Name)
    }
}
