﻿<?php
$dbhost = 'IHR DATENBANK-HOST';
$dbuser = 'IHR BENUTZERNAME';
$dbpasswort = 'IHR PASSWORT';
$dbname = 'IHR DATENBANKNAME';
$tabelle = 'notizbuch';

// Datenbankverbindung mit mysqli (PHP5)
$db = new mysqli($dbhost, $dbuser, $dbpasswort, $dbname);
// HTTP-POST: Daten werden gespeichert oder gelöscht
if ($_POST) {
 if ($_POST['id']) $id = $_POST['id'];

 // Daten speichern:
 if ($_POST['aktion'] == 'speichern') {
  // Query mit Platzhaltern vorbereiten
  $stmt = $db->prepare('INSERT ' . $tabelle . ' (id, eintrag) VALUES (?, ?)');
  // ID wird als String übergeben, weil PHP keine großen Zahlen kann :-(
  // PHP-Skript ist ISO-kodiert, Datenbank und Client-Skripte nutzen UTF-8
  $stmt->bind_param('ss', $id, utf8_decode($_POST['eintrag']));
  // Ausgabe taucht in der Debug-Konsole auf
  echo 'Schreibe Eintrag ' . $id;

 // Daten löschen:
 } elseif ($_POST['aktion'] == 'loeschen') {
  // Notiz wird nicht komplett gelöscht, nur ihr Inhalt
  $stmt = $db->prepare('UPDATE ' . $tabelle . ' SET eintrag = NULL WHERE id = ?');
  $stmt->bind_param('s', $id);
  echo 'Lösche Eintrag ' . $id;

 // kein Parameter "aktion" oder falscher Wert dafür
 } else {
  echo 'Ungültige Parameter!';
  exit;
 }
 // Query ausführen, Debug-Ausgabe
 $stmt->execute();
 printf("\n%d Zeilen aktualisiert", $stmt->affected_rows);
 $stmt->close();

// GET-Anfrage: Datenbankinhalt im JSON-Format ausgeben
} elseif ($_SERVER['REQUEST_METHOD'] == 'GET') {
 // SQL-Abfrage
 if ($res = $db->query('SELECT id, eintrag FROM ' . $tabelle .' ORDER BY id')) {
  // zeilenweise einlesen, zu Strings zusammensetzen, in Array packen
  $eintraege = Array();
  while ($obj = $res->fetch_object()) $eintraege[] = '{"id": ' . $obj->id . ', "eintrag": "' . addslashes(utf8_encode($obj->eintrag)) . '"}';
  $res->close();
  // Array ausgeben
  echo '[' . join(',', $eintraege) . ']';
 }
}

// eventuelle Fehler ausgeben
if ($db->error) echo $db->error;
// Datenbankverbindung explizit schließen
$db->close();
?>
