var spacerImage="hidden-marker.png";
var colState; // Globale Arrays fuer den aktuellen Zusammenschieb-Zustand der Tabelle (1=normal; 0=gestaucht)
var rowState; // Globale Arrays fuer den aktuellen Zusammenschieb-Zustand der Tabelle (1=normal; 0=gestaucht)
var spacerWidth=40;	// Breite des Spacers 
var colWidth;	//Globales Array, das speichert, wie breit die Spalten sein sollen, wird automatisch befuellt
var rowHeight; //Globales Array, das speichert, wie breit die Spalten sein sollen, wird automatisch befuellt
var scrollWidth=17;			// Breite des Scrollbalkens

var globalBorder = 20;	// Anzahl der Pixel, die die Tabelle kleiner wird, als das Fenster


function scrollData(){
	var colHead=document.getElementById("columnHeads");
	var rowHead=document.getElementById("rowHeads");
	var data=document.getElementById("data");

	colHead.scrollLeft=data.scrollLeft;
	rowHead.scrollTop=data.scrollTop;
}

// Spalten ein- und ausblenden
function toggleColumn(index){
	// neuen Status merken
	if (colState[index]==0){	// Spalte soll verschwinden
		for (var i=index; i<colState.length; i++) { // Nachbarn durchgehen
			if (colState[i]==0) {	// Falls ebenfalls ausgeblendet 
				colState[i]=1;		// wieder anzeigen
			} else {	// Abbrechen, wenn erster eingeblendeter Nachber gefunden
				break;
			}
		}		
	} else {	// Spalte soll erscheinen
		colState[index]=0;
	}

	refreshColumns();	
}

// Zeilen ein- und ausblenden
function toggleRow(index){
	// ToDo: Hier fehlt Code zum Ein- und Ausblenden der Zeilen 
	refreshRows();
}		

// Setze alle Spalten zurueck
function reset(){
	for (var i=0; i<colState.length; i++)	
		colState[i]=1;
	for (var i=0; i<rowState.length; i++)	
		rowState[i]=1;
	adjustTable();	// und alles neu aufbauen	
}
		
// Sorge dafuer, dass der aktuelle Inhalt von colState sich auch in der Anzeige widerspiegelt
function refreshColumns (){
	// ============================================================
	// 1. Datenspalten ein- und ausblenden
	// ============================================================
	// Baue eine Liste mit allen Zeilen der Datentabelle zusammen
	var rows=document.getElementById("data").getElementsByTagName('tr');
	var numRows=rows.length;
	var numCols=rows[0].getElementsByTagName('td').length;
	
	// Nun gehe alle Daten-Zeilen durch und blende aus und ein
	for (var y=0; y<numRows; y++){
		for (var x=0; x<numCols; x++){
			var div=rows[y].getElementsByTagName('div')[x];
			
			if (colState[x]==1){	// sollen sie sichtbar sein?
				div.style.display="block";	// wenn ja, dann einblenden
			} else { 
				div.style.display="none";		// wenn nein, ausblenden
			}
		}
	}	

	// ============================================================
	// 2. Header und Spacer bearbeiten
	// ============================================================
	// Spalten durchgehen, Spacer an und ausschalten/gruppieren, Platz fuer Spacer schaffen
	var spacer_set=0;
	var headerPixels =0; // wieviele Pixel haette die Kopfzeile denn gern?
	for (var i=0; i< colState.length; i++){
		// aktuelle Header-Spalte suchen
		var header =document.getElementById("Header_"+i).getElementsByTagName('div')[0];
		// dazu passenden Spacer suchen
		var spacer =document.getElementById("Spacer_"+i);

		if (colState[i] == 0) {  // wir haben eine ausgeblendete Spalte vor uns
			header.style.display= "none";	// Spalte ausblenden
			if (spacer_set==0){		// Es wurde in der Umgebung aber noch kein Spacer gesetzt
				spacer.getElementsByTagName('div')[0].style.display="block";	// Spacer einblenden
				spacer_set=1;							// Spacer fuer Umgebung merken
			} else {			// Eine vorige Zelle hat den Spacer schon setzen lassen
				spacer.getElementsByTagName('div')[0].style.display="none";	// Spacer ausblenden
			}
		} else {  // wir haben eine einzublendende Zelle vor uns
				header.style.display= "block";	// Spalte einblenden
				spacer.getElementsByTagName('div')[0].style.display="none";	// Spacer ausblenden
				spacer_set=0;							// Notieren, dass kein Spacer in der Umgebung

				// Platz Schaffen fuer Spacer
				var cut=0;
				if ((i>0) && (colState[i-1]==0))	// Ab Spalte 1: pruefen, ob vor der Zelle ein Spacer steht
					 cut+=(spacerWidth/2);		// Wenn ja, Platz fuer Spacer abknappsen
				if ((i<colState.length-1) && (colState[i+1]==0))	// bis zur vorletzten Spalte: pruefen, ob dahinter ein Spacer kommt
					 cut+=(spacerWidth/2);		// Wenn ja, Platz fuer Spacer abknappsen			
	
				//debug(cut);
				headerPixels+=colWidth[i];	// Merken, wieviele Pixel belegt sind
				header.style.width=colWidth[i] - cut  +"px";	// Header-Breite setzen (mit Beschnitt)
		}
	}	
	
	// ============================================================
	// 3. Breite der Teilbereiche festlegen
	// ============================================================
	var dataDiv=document.getElementById("data");
	var headerDiv=document.getElementById("columnHeads");
	if ((rowHeaderWidth+headerPixels) > containerWidth){	// Haben wir mehr Header als Platz fuer die Darstellung?
		// Der Datencontainer darf die ganze Breite einnehmen
		dataDiv.style.width=(containerWidth-rowHeaderWidth)+"px";
		
		// Die Spaltenkoepfe sind so breit wie der Nutzdatenbereich (beruecksichtigt Scrollbalken	
		headerDiv.style.width=(containerWidth-rowHeaderWidth-scrollWidth)+"px";
	} else { //Es gibt mehr Platz als benoetigt
		
		dataDiv.style.width=headerPixels+scrollWidth+"px";
		headerDiv.style.width=headerPixels+"px";			
	
		// Weil der dusselige iPad-Browser die tabelle auseinander zerrt, wenn sie nicht ganz voll ist, muessen wir ein enges div drum rum zurren
		if (headerPixels > 0){	// Sind ueberhaupt noch header zu sehen?
			headerDiv.style.width=headerPixels+"px";
		}else {	// Alle Spalten weg
			headerDiv.style.width=spacerWidth+"px";
			dataDiv.style.width=0 +"px";
		}
	}
}

// Sorge dafuer, dass der aktuelle Inhalt von rowState sich auch in der Anzeige widerspiegelt
function refreshRows (){
	// ToDo: Hier fehlt Code zum Bearbeiten der Zeilen 
}

function init(){
	// Zeile mit den Spaltenkoepfen
	var headerRow=document.getElementById("columnHeads").getElementsByTagName('tr')[0];
	
	// Spaltenkoepfe suchen
	var cols=headerRow.getElementsByTagName('td');
	
	// Spaltenzahl bestimmen
	numCols=cols.length;

	// Anzahl der Datenzeilen und -spalten ermitteln 
	numRows=document.getElementById("data").getElementsByTagName('tr').length;
	
	// Statusarrays initialisieren
	rowState= new Array(numRows);
	colState= new Array(numCols);
	for (var i=0; i<rowState.length; i++)	rowState[i]=1;
	for (var i=0; i<colState.length; i++)	colState[i]=1;
		
	// Suche die Zelle ganz links oben. Sie liefert die Hoehe der Spaltenkoepfe und die Breite der Zeilenkoepfe 
	var corner=document.getElementById("corner");
	
	// Auslesen, wie gross die Headerbereiche sind
	rowHeaderWidth = corner.clientWidth;
	colHeaderHeight =  corner.clientHeight;	
	
	// Auslesen, wie breit die Spaltenkoepfe sind:	
	var header=document.getElementById("columnHeads").getElementsByTagName("td");
	var data=document.getElementById("data").getElementsByTagName("tr");
	colWidth= new Array(numCols);
	for (i=0; i<colWidth.length; i++){
			colWidth[i]=header[i].clientWidth+spacerWidth;
	}
	
	// Auslesen, wie hoch die Zeilenkoepfe sind:	
	var header=document.getElementById("rowHeads").getElementsByTagName("tr");
	rowHeight= new Array(numRows);
	for (i=0; i<rowHeight.length; i++)
		rowHeight[i]=header[i].getElementsByTagName("td")[0].clientHeight;
	
	// Uebertragen von Breite und Hoehe der Koepfe auf die Datenzellen
	var data=document.getElementById("data").getElementsByTagName("tr");
	for (y=0; y<rowHeight.length; y++){
		cells=data[y].getElementsByTagName("div");
		for (i=0; i<colWidth.length; i++){
			cells[i].style.width=(colWidth[i])+"px";
			cells[i].style.height=(rowHeight[y])+"px";
		}
	}

	// Spacer schon mal vorsorglich in die Header-zeile einfuegen, aber verstecken:
	// Es kommt vor jede Zelle genau ein Spacer und zwar von hinten nach vorn, damit der Index nicht weglueuft

	// aber erstmal die eigentlichen Zellen mit Namen versehen
	for (var i=0; i<numCols;i++){
		cols[i].id="Header_"+i;
	}
	
	for (var i=numCols;i>0;i--){
		var index=i-1;
		var spacer=headerRow.insertCell(index);
		spacer.innerHTML="<div style=\"overflow:hidden; \"><img src=\""+spacerImage+"\" onclick=\"toggleColumn("+index+")\"></div>";
		spacer.id="Spacer_"+index;
		spacer.getElementsByTagName('div')[0].style.display="none";
		spacer.style.padding="0px";	
		spacer.style.borderCollapse="collapse";
	}
	
	// Ein paar Anpassungen und initialisierungen mit dem ersten Spacer
	spacer_cell=document.getElementById("Spacer_0");	
		
	spacer_cell.getElementsByTagName('div')[0].style.width=spacerWidth/2 +"px";	// Der erste ist nur halb so breit
	spacer_cell.getElementsByTagName('img')[0].align="right";		// Und wird links beschnitten
	
	
	initialized=1;		// ab jetzt kann es los gehen
	adjustTable();
}

// Alles was mit der Orientierung und der Fenstergroesse zu tun hat
function adjustTable(){
	if (initialized==0){	// keinesfalls ausfuehren, bevor nicht init einmal gelaufen ist
		return;
	}
			
	var globalContainer=document.getElementById("container");
//			globalContainer.style.width=window.innerWidth-globalBorder+"px";
//			globalContainer.style.height=window.innerHeight-globalBorder+"px";
	
	containerWidth = parseInt(globalContainer.clientWidth); 	// Breite der gesamten Tabelle
	containerHeight = parseInt(globalContainer.clientHeight);	// Huehe der gesamten Tabelle

	refreshColumns();
	refreshRows();			
}

//Globale Handler
window.onload = init; 
window.onresize = adjustTable;
window.onorientationchange = adjustTable
