using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace FireBirds
{
    /// <summary>
    /// Hauptklasse 
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        
        /// <summary>
        /// Stapelverarbeitung
        /// Kann einen Kanal zur Grafikkarte ffnen und Schliessen
        /// </summary>
        SpriteBatch spriteBatch;
        
        
        /// <summary>
        /// Variable welche unser Player.cs File reprsentiert
        /// Diese muss auch gleich mittels einer neuen Instanz geladen werden.
        /// </summary>
        Player player = new Player();

        /// <summary>
        /// Liste der Gegner
        /// </summary>
        List<Enemy> enemyList = new List<Enemy>();
        
        /// <summary>
        /// Zufallszahl Generator
        /// </summary>
        Random randomGenerator = new Random();
        double timer;
        
        /// <summary>
        /// Variable welche unser File ScrollingBackground.cs reprsentiert
        /// </summary>
        ScrollingBackground scrollingBackground = new ScrollingBackground();
      
        /// <summary>
        /// Sound Variable
        /// </summary>
        SoundEffect soundBackground;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        
        protected override void Initialize()
        {
             base.Initialize();
        }

        /// <summary>
        /// In dieser Funktion laden wir smtliche Grafiken wie auch unsere Hintergrundmusik
        /// </summary>
        protected override void LoadContent()
        {
            // Erstellung einer neuen Stapelverarbeitung mit der Grafikkarte als Ziel fr das Zeichnen
            spriteBatch     = new SpriteBatch(GraphicsDevice);

            soundBackground = Content.Load<SoundEffect>("Sound\\Fire_Birds");
      
            //Mit Play spielen wir den zuvor geladenen Sound ab
            soundBackground.Play();
      
            player.LoadContent(Content, GraphicsDevice);
            scrollingBackground.LoadContent(Content, GraphicsDevice);
        }

        
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Update Funktion
        /// Wird in jedem Frame 1x Aufgerufen
        /// Hier befindet sich unsere gesammte Logik 
        /// </summary>
        protected override void Update(GameTime gameTime)
        {
            // Wir addieren zu timer die verstrichene Zeit zwischen dem aktuellen und dem letzten Frame zu
            timer += gameTime.ElapsedGameTime.TotalSeconds;

            if (timer > 2.0)
            {
                timer = 0;

                //Ein neuer Gegner wird erstelle und der Liste hinzugefgt
                Enemy newEnemy = new Enemy();
                newEnemy.LoadContent(Content, GraphicsDevice);
                newEnemy.recEnemyPositionAndDimension.X = randomGenerator.Next(0, GraphicsDevice.Viewport.Width);
                enemyList.Add(newEnemy);
            }

            //Es wird jedes einzelne Element aus der Liste angewhlt
            foreach (Enemy enemy in enemyList)
            {
                //Die Funktion Update in welcher wir den Player bewegen wird aufgerufen
                enemy.Update();
                
                //Wir rufen die Funktion CheckCollision in unsererm player auf und bergeben das aktuelle Rectangle von unsererm Gegner
                if (player.CheckCollision(enemy.recEnemyPositionAndDimension))
                {
                    //Findet eine Kollision statt, so schliessen wir das Programm
                    Exit();
                }
            }
             
            player.Update();
            scrollingBackground.Update();

            base.Update(gameTime);
        }

        /// <summary>
        //  Draw Funktion
        /// Wird in jedem Frame 1x Aufgerufen
        /// Hier befindet sich all unsere Anweisungen, welche die Grafiken Zeichnet 
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.White);

            //Der Kanal zur Grafikkarte wird geffnet
            spriteBatch.Begin();

                //Aufruf der Draw Funktion von unseren ScrollingBackground Objekt
                scrollingBackground.Draw(spriteBatch);
                
                player.Draw(spriteBatch);

                foreach (Enemy enemy in enemyList)
                    enemy.Draw(spriteBatch);

            //Der Kanals zur Grafikkarte wird geschlossen
            spriteBatch.End();
            

            base.Draw(gameTime);
        }
    }
}
