#!/bin/bash
#################################################################
#                                                               #
# Mirror script for Apple updates                               #
# Author: Juergen-Michael Radtke                                #
# Created: March 26th, 2010                                     #
# Modified: April 6th, 2011 by A. Beier                         #
#           - changed find command in cleaning section          #
#           - changed wget logfile path for easier Mac usage    #
#################################################################
#
# based on a script by Andrew Wellington
# LICENCE: 
# Copyright (C) 2005 Andrew Wellington.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or
# without modification, are permitted provided that the following
# conditions are met:
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
#
#---------------------------------------------------------------#
#								#
# Take care that we are running only once at a time		#
#								#
#---------------------------------------------------------------#
LOCKFILE=/srv/mirror/sumirror/jrsus.lock
if [ -f $LOCKFILE ]
then
	echo "-------------------------------------------------------------------"
	echo ""
	exit 0
fi
trap "{ rm -f $LOCKFILE ; exit 255; }" EXIT	# Upon exit, remove lockfile.
touch $LOCKFILE					# Create lock file
#
#
#---------------------------------------------------------------#
#								#
# Define catalog URL						#
#								#
#---------------------------------------------------------------#
#
#
# Änderungen sind nur an den Variablen SULOCALHOST und LOCALDIR nötig
#
#
LOCALDIR="/srv/mirror/sumirror"			# Wo liegen auf unserem Server die Daten?
SULOCALHOST="miniTest.local/sumirror"	# Über welche Adresse erreicht man die Daten im LAN?
#
#
SUMASTERHOST="swcdn.apple.com"			# Download server from apple is ..
CATALOGPATH="content/catalogs/others"	# Where catalogs are stored
#CATFILE="index-snowleopard.merged-1.sucatalog"  # Snowleopard only
CATFILE="index-leopard-snowleopard.merged-1.sucatalog"  # Leopard + Snowleopard
SUMASTER="http://$SUMASTERHOST/$CATALOGPATH/$CATFILE"
LOCALCATALOG="$LOCALDIR/$CATALOGPATH/index-local.sucatalog"	# Local catalog file name
#
#
#---------------------------------------------------------------#
#								#
# Define file names						#
#								#
#---------------------------------------------------------------#
URLLIST=$LOCALDIR/urllist			# list of URLs to be downloaded
FILELIST=$LOCALDIR/filelist			# list of local file names
EXISTLIST=$LOCALDIR/existlist		# list of existing files
OLDLIST=$EXISTLIST.old				# previous version of existing files
DELETELIST=$LOCALDIR/deletelist		# list of revoked files
NEWLIST=$LOCALDIR/newlist			# list of files not present before
WGETLOG=$LOCALDIR/jrsus-wget.log	# Logfile for collecting wget messages
#
# 
#---------------------------------------------------------------#
#								#
# Some progs we are going to use				#
#								#
#---------------------------------------------------------------#
GREP="`which grep`"
SED="`which sed`"
FIND="`which find`"
TR="`which tr`"
MV="`which mv`"
RM="`which rm`"
SORT="`which sort`"
WGET="`which wget`"
XARGS="`which xargs`"
COMM="`which comm`"
DATECMD="`which date`"
DATECMD=$DATECMD' +%Y-%m-%d_%T'



#
#---------------------------------------------------------------#
#								#
# Get catalog file						#
#								#
#---------------------------------------------------------------#
echo "-------------------------------------------------------------------"
echo "$($DATECMD) get catalog file"
$RM $LOCALCATALOG						# Remove local catalog to prevent inconsistencies
$WGET -a $WGETLOG -xnH -N -P $LOCALDIR $SUMASTER
SUMASTERLOCAL=$LOCALDIR/`echo $SUMASTER | cut -d\/ -f4-`	# This is the path of our copy
#
#
#
#---------------------------------------------------------------#
#								#
# Now create the list URLs to be downloaded			#
# and a list of local filenames					#
#								#
#---------------------------------------------------------------#
echo "$($DATECMD) generate download list"
$GREP $SUMASTERHOST $SUMASTERLOCAL | $TR -d "\t" | $SED 's/<string>//g;s/<\/string>//g' > $URLLIST
#   					|			delete <string> tags
#					delete leading spaces and tabs
$SED "s#http://$SUMASTERHOST#$LOCALDIR#g" < $URLLIST | $SORT > $FILELIST	# sorted list of files to be downloaded
$FIND $LOCALDIR/content/downloads -type f | $SORT > $OLDLIST	# see what we have 

$COMM -1 -3 $OLDLIST $FILELIST > $NEWLIST		# generate a list of new files
if [ $? -ne 0 ]
then
	echo "Error on generating $NEWLIST"
fi
#-------------------------------------------------------------------
#
#
#---------------------------------------------------------------#
#								#
# Download all newer files including directory structure	#
#								#
#---------------------------------------------------------------#
cd $LOCALDIR
echo "$($DATECMD) start file download"
$WGET -a $WGETLOG -xnH -N -P $LOCALDIR -i $URLLIST
echo "$($DATECMD) file download finished"
#
#
#
#---------------------------------------------------------------#
#								#
# Find all files in our local mirror				#
# and compare with the download catalog				#
#								#
#---------------------------------------------------------------#
$FIND $LOCALDIR/content/downloads -type f | $SORT > $EXISTLIST
$COMM -2 -3 $EXISTLIST $FILELIST > $DELETELIST		# files not needed anymore
if [ $? -eq 0 ]
then
	#---------------------------------------------------------------#
	#								#
	# Delete obsolete files						#
	#								#
	#---------------------------------------------------------------#
	echo "$($DATECMD) start cleaning"
	while read MYLINE
	do
		rm $MYLINE
	done < $DELETELIST
	cd $LOCALDIR
	$FIND $LOCALDIR/content/downloads -d -type d -empty -exec rmdir {} \;		# Remove empty directories
	echo "$($DATECMD) cleaning finished"
fi
#
#
#
#
#---------------------------------------------------------------#
#								#
# Create the local catalog file					#
#								#
#---------------------------------------------------------------#
sed "s#swcdn.apple.com#$SULOCALHOST#g" < $LOCALDIR/$CATALOGPATH/$CATFILE >  $LOCALCATALOG


echo "$($DATECMD) mirror process finished"
echo "-------------------------------------------------------------------"
echo " "
 
