// Numactrl.cpp 
// Andreas Stiller, c't, May 2011 
// Shows the Available Memory for NUMA Allocation 


#include "stdafx.h"
#include <stdio.h>
#include <stdarg.h>  // for va_arg
#include "Numactrl.h"
#define KB 1024
#define MB (KB*KB) 
#define GB (MB*KB)


#define MAX_LOADSTRING 100

// Globale Variablen:
HINSTANCE hInst;								// Aktuelle Instanz
TCHAR szTitle[MAX_LOADSTRING];					// Titelleistentext
TCHAR szWindowClass[MAX_LOADSTRING];			// Klassenname des Hauptfensters

// Vorwrtsdeklarationen der in diesem Codemodul enthaltenen Funktionen:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	TimerDialog(HWND, UINT, WPARAM, LPARAM);

HWND MyHWnd;
TCHAR* screen; 
int line;
int lstart;
ULONG		maxnode;
WORD		MaxGroups;  
WORD		ActiveGroups;
int         sec;
int         RepTime=2000;

#ifdef _WIN32
#define vsnprintf _vsnprintf
#endif



int APIENTRY _tWinMain(HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	// TODO: Hier Code einfgen.
	MSG msg;
	HACCEL hAccelTable;

	// Globale Zeichenfolgen initialisieren
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_NUMACTRL, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Anwendungsinitialisierung ausfhren:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_NUMACTRL));

	// Hauptnachrichtenschleife:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNKTION: MyRegisterClass()
//
//  ZWECK: Registriert die Fensterklasse.
//
//  KOMMENTARE:
//
//    Sie mssen die Funktion verwenden,  wenn Sie mchten, dass der Code
//    mit Win32-Systemen kompatibel ist, bevor die RegisterClassEx-Funktion
//    zu Windows 95 hinzugefgt wurde. Der Aufruf der Funktion ist wichtig,
//    damit die kleinen Symbole, die mit der Anwendung verknpft sind,
//    richtig formatiert werden.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NUMACTRL));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_NUMACTRL);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNKTION: InitInstance(HINSTANCE, int)
//
//   ZWECK: Speichert das Instanzenhandle und erstellt das Hauptfenster.
//
//   KOMMENTARE:
//
//        In dieser Funktion wird das Instanzenhandle in einer globalen Variablen gespeichert, und das
//        Hauptprogrammfenster wird erstellt und angezeigt.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;

	hInst = hInstance; // Instanzenhandle in der globalen Variablen speichern

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		0, 0, 500, 150, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}



void xprintf (const TCHAR* s, ...) {
	static TCHAR szBuf[200];
	va_list argList;
	va_start(argList, s);
	_vsntprintf_s(szBuf, sizeof(szBuf)-10,s, argList);

	if (line++ <25)  _tcscat (screen,szBuf);
	SendMessage (MyHWnd,WM_SETTEXT,0,(LPARAM) screen);
}


//
//  FUNKTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ZWECK:  Verarbeitet Meldungen vom Hauptfenster.
//
//  WM_COMMAND	- Verarbeiten des Anwendungsmens
//  WM_PAINT	- Zeichnen des Hauptfensters
//  WM_DESTROY	- Beenden-Meldung anzeigen und zurckgeben
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	RECT clRect;
	ULONGLONG AvailableBytes;
	GROUP_AFFINITY ProcessorMask;

	switch (message)
	{
	case WM_CREATE: 
		line=0; screen= (TCHAR*) malloc (25*160);
		screen[0]=0;
		GetClientRect(hWnd,&clRect); 
		MyHWnd = CreateWindow(TEXT("EDIT"), szTitle, WS_CHILDWINDOW | WS_VISIBLE | ES_READONLY | ES_MULTILINE | ES_AUTOVSCROLL,
			clRect.left+3, clRect.top+3,clRect.right-clRect.left-6,clRect.bottom-clRect.top-6, hWnd, NULL, hInst, NULL);
		GetNumaHighestNodeNumber(&maxnode);
		MaxGroups=GetMaximumProcessorGroupCount();
		ActiveGroups= GetActiveProcessorGroupCount();
		xprintf (TEXT("Max Groups= %d, Active Groups %d, Nodes: %d\r\n"),MaxGroups,ActiveGroups,maxnode+1); 
		lstart=strlen(screen);
		sec=0;
		SetTimer(hWnd,1,RepTime,NULL);
		SendMessage (hWnd,WM_TIMER,0,0);
		break; 
	case WM_TIMER:
		screen[lstart]=0;line=1; 
		for (UCHAR n=0; n<=maxnode;n++) { 
			if (!GetNumaAvailableMemoryNode(n, &AvailableBytes)) xprintf (TEXT("oops, Error with GetNumaAvailableMemoryNode\r\n"));
			if (!GetNumaNodeProcessorMaskEx(n,&ProcessorMask)) xprintf (TEXT("oops, Error with GetNumaProcessorMaskEx\r\n"));
			xprintf (TEXT("Node: %d, Group: %d, Mask: %016llx, Available Memory %5.1f GByte\r\n"),n,ProcessorMask.Group,ProcessorMask.Mask,(double)AvailableBytes/GB); 
		}    
		xprintf (TEXT("time %d s \r\n"),sec/1000); 
		sec+=RepTime; 
		if (0==RepTime) KillTimer(hWnd,1);
		else SetTimer(hWnd,1,RepTime,NULL);
		break;
	case WM_SIZE: {
		//GetClientRect(hWnd,&clRect); 

		int nWidth = LOWORD(lParam); 
		int nHeight = HIWORD(lParam);

		SetWindowPos(MyHWnd, 0, 0, 0, nWidth-6, nHeight-6, SWP_NOMOVE |SWP_DRAWFRAME );  
				  }
				  break;

	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Menauswahl bearbeiten:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case ID_OPTIONS_TIME:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG1), hWnd, TimerDialog);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Hier den Zeichnungscode hinzufgen.
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Meldungshandler fr Infofeld.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}


char szTimerstr[10]; 
INT_PTR CALLBACK TimerDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		_itoa(RepTime,szTimerstr,10);
		SetDlgItemText(hDlg,IDC_EDIT1,szTimerstr);
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			if (!GetDlgItemText(hDlg,IDC_EDIT1,szTimerstr,10)) strcpy (szTimerstr,"0");
			RepTime=atoi(szTimerstr);

			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}