#pragma once
#include <windows.h>
#include <stdio.h> 
#define USENEWSTATUS                // define for more than 128 Objects 
#define TEST_MAXIMUM_WAIT_OBJECTS 2 // for Tests limit MAXIMUM_WAIT_OBJECTS

#ifdef USENEWSTATUS    
 #define WAIT_ABANDONEDEX_0 0x1000
 #define WAIT_TIMEOUTEX WAIT_TIMEOUT+0x1000
#else
 #define WAIT_ABANDONEDEX_0 WAIT_ABANDONED_0 
 #define WAIT_TIMEOUTEX WAIT_TIMEOUT
#endif
#define WAIT_OBJECTEX_0 WAIT_OBJECT_0

#ifdef TEST_MAXIMUM_WAIT_OBJECTS
 #undef MAXIMUM_WAIT_OBJECTS
 #define MAXIMUM_WAIT_OBJECTS TEST_MAXIMUM_WAIT_OBJECTS
#endif 
#define MAXIMUM_WAIT_OBJECTSEX MAXIMUM_WAIT_OBJECTS
#define WAIT_NOTVALID 0xFFFFFF00
#define WAIT_RAISE_EXCEPTION 0xFFFFFF01

#define MAGIC 0x12345678


enum WAITTYPE {WAITANYTHREADS,WAITALLTHREADS,WAITALLSEQUENTIAL};  
#define WAITALLDEFAULT WAITALLSEQUENTIAL

typedef struct WThreadData {	
    DWORD Count;
    PHANDLE pHandles;
	DWORD Milliseconds;
	BOOL  WaitAll;
	DWORD Magic;
	DWORD nr;
	HANDLE pLocalHandles[MAXIMUM_WAIT_OBJECTS];	
	BOOL  Terminated;
    DWORD Status;
	VOID* Parent;

} WTHREADDATA, *PWTHREADDATA;





#ifdef __cplusplus 
 extern "C" DWORD WINAPI WaitForManyObjects(
  __in  DWORD Count,
  __in  const PHANDLE pHandles,
  __in  BOOL WaitAll,
  __in  DWORD Milliseconds
  );

class CWait
{
  public:                                             
    CWait(WAITTYPE WaitType, int aMaxObjects=0);                  
   ~CWait();                     
    						
    DWORD WaitForManyObjects(
						__in  DWORD Count,
						__in  const PHANDLE pHandles,
						__in  BOOL WaitAll,
						__in  DWORD Milliseconds);

    
   DWORD GetCreateResult();
	
  private:            
	DWORD TerminateWaitByEvent (int ExcludeThread);	
	DWORD GetWaitAllStatus( __in DWORD WStatus );
	DWORD GetWaitAnyStatus(	__in DWORD WStatus); 

    int		MaxObjects;
	WAITTYPE WaitType; 
    PHANDLE pWHandles;
	int		WThreadCount;
 	DWORD  Maximum_Wait_Objects;
	DWORD  LastObjCount;
	HANDLE  hTerminateEvent;
	PWTHREADDATA pWThreadData;
    DWORD   CreateResult;

};


#else

DWORD WINAPI WaitForManyObjects(
  __in  DWORD Count,
  __in  const PHANDLE pHandles,
  __in  BOOL WaitAll,
  __in  DWORD Milliseconds
  );
#endif 



