#include <windows.h>
#include <tchar.h>
#include <strsafe.h>
#include "utility.h" //Timer, threadsafe printf etc. 
#include "WaitForMoClass.h"


//*********************** WaitForManyObjects Test ******************************************
// The Define Area 
// You can change here the via defines the amount of different objects and timeouts of master and
// Mutex threads
// the runtime of workthread (i) is 2000 + 500*i [ms]. 
// in WaitForMoClass.h you can limit for tests MAXIMUM_WAIT_OBJECTS to TEST_MAXIMUM_WAIT_OBJECTS 
// for less than 64 Objects you can test in both ways: the classic WaitForMultiple: MASTER_USEMANY false or 
// WaitForMany: MASTER_USEMANY true


#define MAX_THREADS 5
#define MAX_EVENTS 1
#define MAX_MUTEX 1 
#define MAX_SEMAPHOR 0 
#define BUF_SIZE 255

#define MUTEX_DORELEASE TRUE
#define MUTEX_MILLISECS 1000
#define MASTER_HASEVENT FALSE
#define MASTER_HASMUTEX TRUE
#define MASTER_MILLISECS INFINITE
#define MASTER_USEMANY  TRUE
#define MASTER_WAITALL FALSE
#define MASTER_WORKTHREADCOUNT 5

  
HANDLE  hMaster=0; 
DWORD   MasterId=0;
HANDLE  hEvent=0;
HANDLE  hMutex=0;
DWORD   MutexId=0; 
HANDLE  hMutexThread;


DWORD WINAPI WorkThread( LPVOID lpParam );
void ErrorHandler(LPTSTR lpszFunction);

// Sample custom data structure for threads to use.
// This is passed by void pointer so it can be any data type
// that can be passed using a single void pointer (LPVOID).
typedef struct WorkThreadData {

    int val1;
    int val2;
    BOOL DoTerminate;
    DWORD SleepTime;
} WorkThreadData, *PWorkThreadData;

PWorkThreadData pDataArray[MAX_THREADS];
DWORD   dwThreadIdArray[MAX_THREADS];
HANDLE  hThreadArray[MAX_THREADS+MAX_EVENTS+MAX_MUTEX+MAX_SEMAPHOR]; 


typedef struct MasterThreadData {

    DWORD MilliSeconds;	
    DWORD WaitAll;
    BOOL  UseMany;
    int   WorkThreadCount;
    BOOL  HasMutex;
    BOOL  HasEvent;
} MasterThreadData, *PMasterThreadData;



DWORD WINAPI MasterThread( LPVOID lpParam )  {  
    DWORD status;  
    DWORD HandleCount;
    PMasterThreadData pData;

    int i;
    if (NULL==lpParam) { 
        printf ("Error, no pointer to data of master thread specified\n");
        ExitProcess(3);
    }
    pData=(PMasterThreadData) lpParam; //copy parameters to local structure 
    if (pData->UseMany) xtprintf(TEXT("%8d s:WaitMany with MaximumWaitObjects= %d,WaitAll= %d, Timeout %d\n"),stime(),MAXIMUM_WAIT_OBJECTSEX,pData->WaitAll, pData->MilliSeconds); 
    else xtprintf(TEXT("%8d s WaitMultiple with MaximumWaitObjects= %d, WaitAll=%d, Timeout %d\n"),stime(),MAXIMUM_WAIT_OBJECTS,pData->WaitAll,pData->MilliSeconds); 

    // Create MAX_THREADS worker threads.

    for( i=0; i<pData->WorkThreadCount; i++ )
    {
        // Allocate memory for thread data.

        pDataArray[i] = (PWorkThreadData) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY,
            sizeof(WorkThreadData));

        if( pDataArray[i] == NULL )
        {
            // If the array allocation fails, the system is out of memory
            // so there is no point in trying to print an error message.
            // Just terminate execution.
            ExitProcess(2);
        }

        // Generate unique data for each thread to work with.

        pDataArray[i]->val1 = i;
        pDataArray[i]->val2 = i+100;
        pDataArray[i]->DoTerminate = FALSE;
        pDataArray[i]->SleepTime=i*500+2000;
        // Create the thread to begin execution on its own.

        hThreadArray[i] = CreateThread( 
            NULL,                   // default security attributes
            0,                      // use default stack size  
            WorkThread,				// thread function name
            pDataArray[i],          // argument to thread function 
            0,                      // use default creation flags 
            &dwThreadIdArray[i]);   // returns the thread identifier 


        // Check the return value for success.
        // If CreateThread fails, terminate execution. 
        // This will automatically clean up threads and memory. 

        if (hThreadArray[i] == NULL) 
        {
            ErrorHandler(TEXT("CreateThread"));
            ExitProcess(3);
        }
    } // End of main thread creation loop.

    // Wait until all threads have terminated.
    //hThreadArray[3]=(HANDLE)0x12345678;
    HandleCount=pData->WorkThreadCount;
    if (pData->HasEvent) hThreadArray[HandleCount++]=hEvent;
    if (pData->HasMutex) hThreadArray[HandleCount++]=hMutex; 
    if (pData->UseMany) status=WaitForManyObjects(HandleCount, hThreadArray, pData->WaitAll, pData->MilliSeconds);
    else status=WaitForMultipleObjects(HandleCount, hThreadArray, pData->WaitAll, pData->MilliSeconds);


    // Close all thread handles and free memory allocations.

    if (pData->WaitAll) {
        if (pData->UseMany) switch (status) { 
          case WAIT_OBJECTEX_0: xtprintf (TEXT("%8d s: all objects signaled\n"),stime()); break;
          case WAIT_ABANDONEDEX_0: xtprintf (TEXT("%8d s:an abandoned Mutex signaled\n"),stime()); break;
          case WAIT_TIMEOUT: xtprintf (TEXT("%8d s:Timeout occured after %d ms\n"),stime(),pData->MilliSeconds); break;
          case WAIT_FAILED:xtprintf (TEXT("%8d s:Wait Failed\n"),stime()); break;
          default: xtprintf (TEXT("%8d s:oops, unknown Error status= 0x%x\n"),stime(),status); break;
        }
        else switch (status) {
          case WAIT_OBJECT_0: xtprintf (TEXT("%8d s: all objects signaled\n"),stime()); break;
          case WAIT_ABANDONED_0: xtprintf (TEXT("%8d s:an abandoned Mutex signaled\n"),stime()); break;
          case WAIT_TIMEOUT: xtprintf (TEXT("%8d s:Timeout occured after %d ms\n"),stime(),pData->MilliSeconds); break;
          case WAIT_FAILED:xtprintf (TEXT("%8d s:Wait Failed\n"),stime()); break;
          default: xtprintf (TEXT("%8d s:oops, unknown Error status= 0x%x\n"),stime(),status); break;
        }


    } 
    else 
    {
        xtprintf (TEXT("%8d s:status= 0x%x\n"),stime(),status);
        for(i=0; i<pData->WorkThreadCount; i++) pDataArray[i]->DoTerminate=TRUE;
        if (status != WAIT_FAILED) status=WaitForMultipleObjects(pData->WorkThreadCount, hThreadArray, TRUE,6000); 
        else  {
            for(i=0; i<pData->WorkThreadCount; i++) {
                status=WaitForSingleObject(hThreadArray[i],6000);
                if (status==WAIT_FAILED)  printf ("Thread %d, invalid Handle\n",i); 
                if (status==WAIT_TIMEOUT) printf ("Thread %d doesn't terminate in time\n",i);
            }

        }
    }

    for(i=0; i<pData->WorkThreadCount; i++)
    {
        CloseHandle(hThreadArray[i]);
        /*
        if(pDataArray[i] != NULL)
        {
        HeapFree(GetProcessHeap(), 0, pDataArray[i]);
        pDataArray[i] = NULL;    // Ensure address is not reused.
        }
        */
    }
    xtprintf (TEXT("%8d s:Master ready\n"),stime());
    return 0;
}


DWORD WINAPI WorkThread( LPVOID lpParam ) 
{ 
    HANDLE hStdout;
    PWorkThreadData pDataArray;

    // Make sure there is a console to receive output results. 

    hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
    if( hStdout == INVALID_HANDLE_VALUE ) 
    {
        HeapFree(GetProcessHeap(), 0, lpParam);
        return 1;
    }

    // Cast the parameter to the correct data type.
    // The pointer is known to be valid because 
    // it was checked for NULL before the thread was created.

    // @Microsoft: bullshit, should always be checked to confirm validity, if 
    // something goes wrong and the thread becomes a zombie 
    // Print the parameter values using thread-safe functions.
    pDataArray = (PWorkThreadData)lpParam; 

    if (pDataArray==NULL) xtprintf(TEXT("%8d s:oops, pDaraArray invalid\n"),stime());
    else {
        if (pDataArray->DoTerminate) xtprintf(TEXT("%8d s:Thread %d start: DoTerminate\n"),stime(),pDataArray->val1);
        else xtprintf(TEXT("%8d s:Thread %d start: Parameters = %d, %d\n"),stime(),pDataArray->val1, pDataArray->val1, pDataArray->val2); 
    }

    //sleep 0 to n*500 ms;
    Sleep (pDataArray->SleepTime);
    xtprintf (TEXT("%8d s:Thread %d end\n"),stime(),pDataArray->val1); 
    HeapFree(GetProcessHeap(), 0, lpParam);
    return 0; 
} 

typedef struct MutexThreadData {

    int MilliSeconds;
    int DoRelease;
} MutexThreadData, *PMutexThreadData;



DWORD WINAPI MutexThread( LPVOID lpParam ) {

    //wait to get the Mutex, should be immediate
    if (WAIT_OBJECT_0!=WaitForSingleObject(hMutex,100)) return 2; 
    SetEvent (hEvent);   // Give signal  got Mutex;
    Sleep (((PMutexThreadData) lpParam)->MilliSeconds);
    if (((PMutexThreadData) lpParam)->DoRelease) ReleaseMutex(hMutex); 
    return 0; 
}


void ErrorHandler(LPTSTR lpszFunction) 
{ 
    // Retrieve the system error message for the last-error code.

    LPVOID lpMsgBuf;
    LPVOID lpDisplayBuf;
    DWORD dw = GetLastError(); 

    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | 
        FORMAT_MESSAGE_FROM_SYSTEM |
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL,
        dw,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
        (LPTSTR) &lpMsgBuf,
        0, NULL );

    // Display the error message.

    lpDisplayBuf = (LPVOID)LocalAlloc(LMEM_ZEROINIT, 
        (lstrlen((LPCTSTR) lpMsgBuf) + lstrlen((LPCTSTR) lpszFunction) + 40) * sizeof(TCHAR)); 
    StringCchPrintf((LPTSTR)lpDisplayBuf, 
        LocalSize(lpDisplayBuf) / sizeof(TCHAR),
        TEXT("%s failed with error %d: %s"), 
        lpszFunction, dw, lpMsgBuf); 
    MessageBox(NULL, (LPCTSTR) lpDisplayBuf, TEXT("Error"), MB_OK); 

    // Free error-handling buffer allocations.

    LocalFree(lpMsgBuf);
    LocalFree(lpDisplayBuf);
}


MutexThreadData MutexData;
MasterThreadData MasterData;

int _tmain() {
    BOOL    HasMutex=FALSE;
    BOOL    HasEvent=FALSE;
    char c;
    DWORD Status;
    InitTimer();

    hEvent=CreateEvent(NULL,TRUE,FALSE,TEXT("MyEvent"));
    if (0==hEvent) { 
        ErrorHandler(TEXT("CreateEvent"));
        ExitProcess(3);
    }

    MutexData.DoRelease=MUTEX_DORELEASE;
    MutexData.MilliSeconds=MUTEX_MILLISECS; 
    MasterData.HasEvent=MASTER_HASEVENT;
    MasterData.HasMutex=MASTER_HASMUTEX ;
    MasterData.MilliSeconds=MASTER_MILLISECS;
    MasterData.UseMany=MASTER_USEMANY;
    MasterData.WaitAll=MASTER_WAITALL;
    MasterData.WorkThreadCount=MASTER_WORKTHREADCOUNT;



    hMutex=CreateMutex(NULL,FALSE,TEXT("MyMutex"));
    if (0==hMutex) { 
        ErrorHandler(TEXT("CreateMutex"));
        ExitProcess(3);
    }

    if (MAX_MUTEX > 0) { //Generate Thread as Mutex Owner 
        hMutexThread = CreateThread( 
            NULL,                   // default security attributes
            0,                      // use default stack size  
            MutexThread,            // thread function name
            &MutexData,             // argument to thread function 
            0,                      // use default creation flags 
            &MutexId);              // returns the thread identifier

        if (0==hMutexThread) { 
            ErrorHandler(TEXT("CreateEvent"));
            ExitProcess(3);
        }
        Status=WaitForSingleObject(hEvent,1000); 

        HasMutex=(WAIT_OBJECT_0==Status);
        if (!HasMutex) { 
            printf ("Can't get Mutex\n");
            ExitProcess (3);
        };
        ResetEvent(hEvent);
    }



    if (MasterData.HasMutex) xtprintf (TEXT("%8d s:MutexThread got Mutex, Mutex %s after %d ms\n"),stime(),MutexData.DoRelease? L"released":L"abandoned", MutexData.MilliSeconds );


    hMaster = CreateThread( 
        NULL,                   // default security attributes
        0,                      // use default stack size  
        MasterThread,           // thread function name
        &MasterData,            // argument to thread function 
        0,                      // use default creation flags 
        &MasterId);             // returns the thread identifier
    if (0==hMaster) {
        ErrorHandler(TEXT("Create MasterThread"));
        ExitProcess(3);
    }

    c=getchar(); 

    if (HasEvent) ResetEvent(hEvent);


    //Cleanup, ok is redundant here because process ends 
    if (0 != hMutex)       CloseHandle (hMutex);
    if (0 != hEvent)       CloseHandle (hEvent); 
    if (0 != hMaster)      CloseHandle (hMaster); 
    if (0 != hMutexThread) CloseHandle (hMutexThread);
    return 0; 
}


