// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: flagsemaphore.h 810be5e9d247 2011/08/17 14:20:52 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __FLAGSEMAPHORE_H_
#define __FLAGSEMAPHORE_H_

#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QMetaType>

namespace FlagSemaphore {

    enum Side { NONE, LEFT, RIGHT };
    enum Direction { UNDEFINED, DOWN, SIDE_DOWN, SIDE, SIDE_UP, UP, OTHER = 0x4000 };

    class Position {
    public:
        Position(int right = UNDEFINED, int left = UNDEFINED) :
                mRight(right),
                mLeft(left)
        { /* ... */ }
        inline bool isValid(void) const { return mRight != UNDEFINED && mLeft != UNDEFINED; }
        inline int right(void) const { return mRight; }
        inline int left(void) const { return mLeft; }
    private:
        int mRight;
        int mLeft;
    };

    typedef QMap<QString, Position> SemaphoreMap;

    class FlagSemaphore // Singleton
    {
    public:
        static FlagSemaphore* instance(void);
        const Position& position(const QString& name) const { return mPositions[name]; }
        const SemaphoreMap& positions(void) const { return mPositions; }


    private:
        FlagSemaphore(void);
        static FlagSemaphore* mInstance;
        static SemaphoreMap mPositions;

        class Watchdog {
        public:
            ~Watchdog() {
                if (FlagSemaphore::mInstance)
                    delete FlagSemaphore::mInstance;
            }
        };

        static Watchdog mWatchdog;
        friend class Watchdog;
    };

}


Q_DECLARE_METATYPE(FlagSemaphore::Side)

#endif // __FLAGSEMAPHORE_H_
