// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: posehelperwidget.cpp 865377b019de 2011/08/16 14:43:19 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include <QtCore/QtDebug>
#include <QPainter>
#include <QPainterPath>

#include "posehelperwidget.h"


PoseHelperWidget::PoseHelperWidget(QWidget* parent) : QWidget(parent)
    , mPose(FlagSemaphore::UNDEFINED, FlagSemaphore::UNDEFINED)
    , mShowPose(false)
    , mOpacity(0.0f)
{
    // ...
}


void PoseHelperWidget::setPose(const FlagSemaphore::Position& pose, bool show, float opacity)
{
    mPose = pose;
    mShowPose = show;
    mOpacity = opacity;
    update();
}


void PoseHelperWidget::paintEvent(QPaintEvent*)
{
    QPainter painter(this);
    if (mShowPose && mPose.isValid()) {
        painter.setRenderHint(QPainter::Antialiasing, true);
        painter.setOpacity(mOpacity);
        painter.fillRect(rect(), QBrush(QColor(22, 44, 55)));
        painter.setPen(Qt::black);

        // draw head
        painter.translate(QPoint(width()/2, 50));
        painter.setBrush(QBrush(QColor(255, 244, 222)));
        painter.drawEllipse(QPoint(0, 15), 12, 12);

        // draw body
        QPainterPath body;
        body.moveTo(-20, 30);
        body.lineTo(-20, 150);
        body.lineTo(-1, 150);
        body.lineTo(-1, 90);
        body.lineTo(1, 90);
        body.lineTo(1, 150);
        body.lineTo(20, 150);
        body.lineTo(20, 30);
        painter.drawPath(body);

        // draw left arm
        painter.resetTransform();
        painter.translate(width()/2+25, 85);
        switch(mPose.left()) {
        case FlagSemaphore::DOWN:
            painter.rotate(0);
            break;
        case FlagSemaphore::SIDE_DOWN:
            painter.rotate(-45);
            break;
        case FlagSemaphore::SIDE:
            painter.rotate(-90);
            break;
        case FlagSemaphore::SIDE_UP:
            painter.rotate(-135);
            break;
        case FlagSemaphore::UP:
            painter.rotate(-180);
            break;
        case FlagSemaphore::OTHER | FlagSemaphore::SIDE_DOWN:
            painter.rotate(45);
            break;
        case FlagSemaphore::OTHER | FlagSemaphore::SIDE_UP:
            painter.rotate(135);
            break;
        }
        painter.setBrush(QBrush(QColor(255, 244, 222)));
        painter.drawRect(-5, 0, 10, 40);
        painter.setBrush(Qt::red);
        QPainterPath leftFlag1;
        leftFlag1.moveTo(5, 40);
        leftFlag1.lineTo(5, 60);
        leftFlag1.lineTo(-15, 60);
        painter.drawPath(leftFlag1);
        painter.setBrush(Qt::yellow);
        QPainterPath leftFlag2;
        leftFlag2.moveTo(5, 40);
        leftFlag2.lineTo(-15, 40);
        leftFlag2.lineTo(-15, 60);
        painter.drawPath(leftFlag2);

        // draw right arm
        painter.resetTransform();
        painter.translate(width()/2-25, 85);
        switch(mPose.right()) {
        case FlagSemaphore::DOWN:
            painter.rotate(0);
            break;
        case FlagSemaphore::SIDE_DOWN:
            painter.rotate(45);
            break;
        case FlagSemaphore::SIDE:
            painter.rotate(90);
            break;
        case FlagSemaphore::SIDE_UP:
            painter.rotate(135);
            break;
        case FlagSemaphore::UP:
            painter.rotate(180);
            break;
        case FlagSemaphore::OTHER | FlagSemaphore::SIDE_DOWN:
            painter.rotate(-45);
            break;
        case FlagSemaphore::OTHER | FlagSemaphore::SIDE_UP:
            painter.rotate(-135);
            break;
        }
        painter.setBrush(QBrush(QColor(255, 244, 222)));
        painter.drawRect(-5, 0, 10, 40);
        painter.setBrush(Qt::red);
        QPainterPath rightFlag1;
        rightFlag1.moveTo(-5, 40);
        rightFlag1.lineTo(-5, 60);
        rightFlag1.lineTo(15, 60);
        painter.drawPath(rightFlag1);
        painter.setBrush(Qt::yellow);
        QPainterPath rightFlag2;
        rightFlag2.moveTo(-5, 40);
        rightFlag2.lineTo(15, 40);
        rightFlag2.lineTo(15, 60);
        painter.drawPath(rightFlag2);

    }
    else {
        painter.eraseRect(rect());
    }
}
