// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: videowidget.h 71f53dc35d8f 2011/09/27 15:51:09 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __VIDEOWIDGET_H_
#define __VIDEOWIDGET_H_

#include <QWidget>
#include <QImage>
#include "nui.h"

class VideoWidget : public QWidget
{
    Q_OBJECT
public:
    explicit VideoWidget(QWidget* parent = NULL);
    QSize minimumSizeHint(void) const { return QSize(320, 240); }
    QSize sizeHint(void) const { return QSize(320, 240); }
    void showSilhouette(bool enabled = true);

protected:
    void paintEvent(QPaintEvent*);

private:
    QImage mFrame;
    bool mShowSilhouette;
    SkeletonList mSkeletons;

public slots:
    void setFrame(const QImage&);
    void setSkeletons(const SkeletonList&);

};

#endif // __VIDEOWIDGET_H_
