#include <Wire.h>
#include <Servo.h>

#include <Max3421e.h>
#include <Usb.h>
#include <AndroidAccessory.h>

#define  LED1_RED       3

#define  SERVO1         2

AndroidAccessory acc("Google, Inc.",
		     "DemoKit",
		     "DemoKit Arduino Board",
		     "1.0",
		     "http://www.android.com",
		     "0000000012345678");
Servo servos[1];


void setup();
void loop();


void init_leds()
{
	pinMode(LED1_RED, OUTPUT);
	analogWrite(LED1_RED, 0);
	
}

byte b1, b2, c;
void setup()
{
	Serial.begin(115200);
	Serial.print("\r\nStart");

	init_leds();
	servos[0].attach(SERVO1);
	servos[0].write(90);

	acc.powerOn();
}

void loop()
{
	
	byte msg[3];
	

	if (acc.isConnected()) {
		int len = acc.read(msg, sizeof(msg), 1);
		if (len > 0) {
			if (msg[0] == 0x2) {
				if (msg[1] == 0x0){
					analogWrite(LED1_RED, msg[2]);
                                        Serial.print("\r\nBrightness changed");
}
				else if (msg[1] == 0x10){
					servos[0].write(map(msg[2], 0, 255, 0, 180));
                                        Serial.print("\r\nServo moved");
}
			} 
		}
		
	} else {
		analogWrite(LED1_RED, 255);
		servos[0].write(90);
	}
	delay(10);
}


