package com.linkesoft.eierlaufen;

import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {
	private Egg egg;
	private SensorManager sensorManager;
	
	final private int numSteps=10;
	
	private Button stopButton;
	private Button startButton;
	private TextView stepCounterText; 
	private TextView timerText;
	private Timer timer;
	private long startTime;
	private int stepCount;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        EggView eggView=(EggView)findViewById(R.id.eggView);
        egg=new Egg(eggView);
        sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        
        stopButton = (Button)findViewById(R.id.stopButton);
        stopButton.setOnClickListener(new View.OnClickListener() {			
			public void onClick(View v) {
				stop();				
			}
		});
        startButton = (Button)findViewById(R.id.startButton);
        startButton.setOnClickListener(new View.OnClickListener() {			
			public void onClick(View v) {
				start();				
			}
		});
        
        eggView.failureHandler=new EggView.FailureHandler() {			
			public void onFailure() {
				stop();
			    Vibrator v = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
			    if(v!=null)
			    	v.vibrate(300); 
				Toast.makeText(MainActivity.this, getString(R.string.EggOffScreen), Toast.LENGTH_LONG).show();
			}
		};
		stepCounterText = (TextView) findViewById(R.id.stepCounterText);
		egg.stepCounterHandler=new Egg.StepCounterUpdateHandler() {			
			public void onStep() {
				stepCount++;
				stepCounterText.setText(""+stepCount);			
				if(stepCount>=numSteps)
				{
					stop();
				    Vibrator v = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
				    if(v!=null)
				    	v.vibrate(300); 
					Toast.makeText(MainActivity.this, getString(R.string.Finished), Toast.LENGTH_LONG).show();
				}
			}
		};
		// Zeitmesser
		timerText=(TextView)findViewById(R.id.timerText);
    }
    
    @Override
    protected void onResume() {
    	super.onResume();
        reset();
        // wenn die App aus dem Hintergrund zurueckkommt, starten wir nicht automatisch den Event-Listener 
        // sondern warten auf einen Neustart mit dem Start-Button
    }
    @Override
    protected void onPause() {
    	// App geht in den Hintergrund oder wird auf andere Weise unterbrochen (z.B. Anruf) -> breche Spiel ab
    	stop(); 
    	super.onPause();
    }
	private void start() {
		reset();
		// zeige Countdown als Popup
		LayoutInflater inflater = (LayoutInflater)
	       this.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		View eggView=findViewById(R.id.eggView);
		final PopupWindow popupWindow = new PopupWindow(inflater.inflate(R.layout.countdownpopup, null, false),
				eggView.getWidth(),eggView.getHeight());
		popupWindow.showAtLocation(eggView, Gravity.CENTER, 0, 0);
		egg.update=false;
		reset();
		registerSensors(); // zum Einschwingen
		String instructions=getString(R.string.Instructions, numSteps);
		Toast.makeText(this, instructions, Toast.LENGTH_SHORT).show();

		// count down jede sec fr 5 sec: 3,2,1, Go (Argumente in ms)
		CountDownTimer countDownTimer = new CountDownTimer(5*1000,1000) {			
			@Override
			public void onTick(long millisUntilFinished) {
				TextView text=(TextView) popupWindow.getContentView().findViewById(R.id.text);
				long count=millisUntilFinished/1000;
				if(count<2)
					text.setText(getString(R.string.Go));
				else
					text.setText(Long.toString(count-1));
			}			
			
			@Override
			public void onFinish() {
				go();
				popupWindow.dismiss();	
			}
		};
		countDownTimer.start();
	}
	// beginne, Ei zu bewegen und Zeit zu messen
	private void go()
	{
		startButton.setVisibility(View.GONE);
		stopButton.setVisibility(View.VISIBLE);
		startTime=System.currentTimeMillis();
		// Zeit kann nur ber einen Handler auf dem Display aktualisiert werden
		final Handler hUpdateTimer=new Handler() {
			@Override
			public void handleMessage(Message msg) {
				   long dt=System.currentTimeMillis()-startTime;
					DecimalFormat f = new DecimalFormat();
					f.setMaximumFractionDigits(2);
					f.setMinimumFractionDigits(2);
				   timerText.setText(f.format(dt/1000f));
			}
		};
		timer=new Timer();
		timer.schedule(new TimerTask() {			
			@Override
			public void run() {
				hUpdateTimer.sendMessage(Message.obtain());
			}
		}, 50, 50); // update in ms
		// los geht's
		egg.resetEgg();
		egg.update=true;		
	}
	
	private void registerSensors()
	{ 
        // Beschleunigung in 3 Raumrichtungen
        Sensor accelerometer = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        sensorManager.registerListener(egg, accelerometer, SensorManager.SENSOR_DELAY_GAME);
        
         // Magnetfeld in 3 Raumrichtungen zeigt zum Nordpol, ca. 20 Grad Richtung Boden geneigt
        Sensor magneticfieldsensor = sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD);
        if(magneticfieldsensor!=null)
        	sensorManager.registerListener(egg, magneticfieldsensor, SensorManager.SENSOR_DELAY_GAME);
        
		// Drehgeschwindigkeit in 3 Raumrichtungen, alternative zur Neigungsmessung mit Accelerometer
        //Sensor gyroscope=sensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE);
        //if(gyroscope!=null)
        // 	sensorManager.registerListener(egg, gyroscope, SensorManager.SENSOR_DELAY_NORMAL);		
	}
	
	private void stop()
	{
        sensorManager.unregisterListener(egg); // unregister listener for all sensors
        egg.update=false;
        timer.cancel();
		startButton.setVisibility(View.VISIBLE);
		stopButton.setVisibility(View.GONE);
	}

	
	private void reset() {
		timerText.setText("0");
		stepCount=0;
		stepCounterText.setText("0");			
		egg.reset();
		egg.update=false;
	}
   

}