# wr.py

import json
from sho import *
from System import TimeSpan,DateTime, Convert
from System.Globalization import CultureInfo

def parseTimeSpan(s):
  hms = map(Convert.ToInt32, s.Split('.'))
  return TimeSpan(hms[0], hms[1], hms[2])

def go():
  f = open("World_Records.json")
  data = json.load(f)
  marathons = [ d for d in data if d["Event"] == "MMARATHON" ]
  dt = [ parseTimeSpan(d['Result']) for d in marathons ]
  athletes = [ d['Athlete'] for d in marathons ]
  labels = [ ]
  for i, item in enumerate(dt):
    labels.append(str(item) + " (" + athletes[i] + ")")
  years = [ d['Year'] for d in marathons ]
  hours = [ x.TotalHours for x in dt]
  plot(years, hours, 'r-', labels=labels)
  horizmajorgridlines(width=0)
  xaxisrange(years[0], years[-1])

go()
