#pragma warning(disable: 4996)

#include <boost/signals2.hpp> 
#include <string> 
#include <iostream> 

class button { 
private: 
	std::string name; 
	boost::signals2::signal<void(button&)> s; 

public: 
	button(const std::string &n) : name(n) {} 
	template <typename Handler> 
	void add_handler(Handler &handler) { s.connect(handler); } 
	template <typename Handler> 
	void remove_handler(Handler &handler) { s.disconnect(handler); } 
	const std::string &get_name() const { return name; } 
	void click() { s(*this); } 

}; 

void handler(button &btn) { 
	std::cout << btn.get_name() << std::endl; 
} 

int main() {
	button btn("OK"); 
	btn.add_handler(handler); 
	btn.click(); 
	btn.remove_handler(handler); 
	btn.click(); 
} 
