﻿Imports System.Windows.Forms
Imports Microsoft.Office.Core

Module modMain
    Public AppName As String = My.Application.Info.Title
    Public AppSubject As String = AppName & "-Mail"
    Public AppInfo As String = "www.briefblitz.com"
    Public IconsInfo As String = "www.visualpharm.com"

    ' CommandBar-Objekte für Outlook 2007
    Public WithEvents comBarButton_WebPrint As CommandBarButton
    Public WithEvents comBarButton_Info As CommandBarButton

    ' ****************************************************************
    ' Outlook-2007-Routinen
    ' ****************************************************************

    Public Sub SymInit()
        Dim Symbolleiste As CommandBar = modCommandBar.SymbolleisteFinden(AppName)

        'Wenn Symbolleiste NICHT existiert, dann...
        If Symbolleiste Is Nothing Then
            '... neu anlegen
            Symbolleiste = modCommandBar.SymbolleisteAnlegen(AppName, False)

            'Wenn das geklappt hat, dann...
            If Symbolleiste IsNot Nothing Then
                With Symbolleiste
                    '... Symbolleiste am oberen Rand andocken...
                    .Position = Microsoft.Office.Core.MsoBarPosition.msoBarTop
                End With
            End If

            'Wenn Symbolleiste schon existiert, dann...
        Else
            '... alle Controls daraus entfernen
            modCommandBar.SymbolleisteLeeren(Symbolleiste)
        End If

        'Wenn Symbolleiste also jetzt existiert, dann...
        If Symbolleiste IsNot Nothing Then
            '... Symbolleiste mit Makrostart-Schaltflächen bestücken
            comBarButton_WebPrint = modCommandBar.ButtonAnlegen(Symbolleiste, MsoButtonStyle.msoButtonIconAndCaption, "Dokumente drucken/speichern", 4, False, False)
            comBarButton_Info = modCommandBar.ButtonAnlegen(Symbolleiste, MsoButtonStyle.msoButtonIcon, "Infos anzeigen", 487, False, False)

            'Symbolleiste sichtbar machen
            Symbolleiste.Visible = True
        End If
    End Sub

    Public Sub SymExit()
        'Symbolleiste löschen
        modCommandBar.SymbolleisteLöschen(AppName)
    End Sub

    ' Beim Anklicken der CommandBar-Schaltfläche comBarButton_WebPrint...
    Private Sub comBarButton_WebPrint_Click(Ctrl As Microsoft.Office.Core.CommandBarButton, ByRef CancelDefault As Boolean) Handles comBarButton_WebPrint.Click
        ' ... "Makro" HandleWPDocuments aufrufen, Meldungen erlaubt
        Call modMain.HandleWPDocuments(True)
    End Sub

    ' Beim Anklicken der CommandBar-Schaltfläche comBarButton_Info...
    Private Sub comBarButton_Info_Click(Ctrl As Microsoft.Office.Core.CommandBarButton, ByRef CancelDefault As Boolean) Handles comBarButton_Info.Click
        ' ... "Makro" ShowInfoDialog aufrufen
        Call modMain.ShowInfoDialog()
    End Sub

    ' ****************************************************************
    ' "Makros" 
    ' ****************************************************************

    Public Sub HandleWPDocuments(Optional ShowMessages As Boolean = False)
        Dim WPFolder As String = GetWPFolder()
        Dim DocCount As Integer = 0

        ' Neue Instanz von frmAction erstellen
        Dim DlgAction As New frmAction

        Try

            ' Alle Unterordner (tragen E-Mail-Adresse des Absenders als Namen) des WebPrint-Ordners durchlaufen
            For Each SenderFolder As String In My.Computer.FileSystem.GetDirectories(WPFolder)
                ' Alle Dateien im jeweiligen Unterordner durchlaufen
                For Each WPDocument As String In My.Computer.FileSystem.GetFiles(SenderFolder)
                    ' Dateizähler erhöhen
                    DocCount += 1

                    With DlgAction
                        ' Pfad der Datei und Mail-Adresse des Absenders übergeben
                        .WPDocument = WPDocument
                        .WPSender = My.Computer.FileSystem.GetName(SenderFolder)

                        ' Dialog anzeigen
                        Dim DlgResult As DialogResult = .ShowDialog
                        ' Wenn Dialog abgebrochen, dann...
                        If DlgResult = DialogResult.Cancel Then
                            ' ... Routine verlassen
                            Return

                            ' Wenn Dialog mit OK beendet (Datei wurde gedruckt oder gespeichert), dann...
                        ElseIf DlgResult = DialogResult.OK Then
                            Try
                                ' ... Datei (sofern nicht schon gelöscht) in Papierkorb löschen
                                My.Computer.FileSystem.DeleteFile(WPDocument, FileIO.UIOption.OnlyErrorDialogs, FileIO.RecycleOption.SendToRecycleBin)
                            Catch ex As Exception
                            End Try

                            ' Wenn Dialog mit Ignore beendet, dann...
                        ElseIf DlgResult = DialogResult.Ignore Then
                            ' ... nichts tun (nächste Datei)
                        End If
                    End With
                Next
            Next
        Catch ex As Exception
        End Try

        ' Wenn kein WebPrint-Dokument gefunden und Meldungen erlaubt, dann...
        If DocCount = 0 AndAlso ShowMessages = True Then
            ' ... diesen Umstand melden
            MessageBox.Show("Aktuell liegen keine " & AppName & "-Dokumente vor.", AppName, MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub

    Public Sub ShowInfoDialog()
        'Neue Instanz von frmInfo anlegen und Dialog anzeigen
        Dim dlgInfo As New frmInfo
        With dlgInfo
            .Text = AppName & " - Info"
            .ShowDialog()
        End With
    End Sub

    ' ****************************************************************
    ' Routinen
    ' ****************************************************************

    Public Function GetOutlookVersion() As Integer
        Return CInt(Val(Globals.ThisAddIn.Application.Version))
    End Function

    Public Function GetWPFolder() As String
        Return My.Computer.FileSystem.CombinePath(My.Computer.FileSystem.SpecialDirectories.MyDocuments, AppName)
    End Function

    Public Function SaveAttachments(NewMailItem As Outlook.MailItem, FolderPath As String) As Boolean
        Dim Success As Boolean = True

        ' Prüfen, ob Speicherordner existiert oder sich anlegen läßt. Falls nicht, dann...
        If PfadValidieren(FolderPath) = False Then
            ' ... Fehlermeldung anzeigen
            MessageBox.Show("Fehler beim Anlegen des WebPrint-Ordners.", AppName, MessageBoxButtons.OK, MessageBoxIcon.Error)
            ' Funktion mit False verlassen
            Return False
        End If

        ' Alle Anhänge der Nachricht durchlaufen
        For Each Attachment As Outlook.Attachment In NewMailItem.Attachments
            Try
                ' Pfadnamen zum Speichern der Anhangdatei festlegen
                Dim PathName As String = My.Computer.FileSystem.CombinePath(FolderPath, Attachment.FileName)
                ' Wenn die Datei bereits besteht, dann...
                If My.Computer.FileSystem.FileExists(PathName) Then
                    ' ... löschen
                    My.Computer.FileSystem.DeleteFile(PathName)
                End If

                ' Anhang speichern
                Attachment.SaveAsFile(PathName)

                ' Im Fehlerfall...
            Catch ex As Exception
                ' ... Success auf False setzen
                Success = False
            End Try
        Next

        ' Ergebnis zurückgeben
        Return Success
    End Function

    Private Function PfadValidieren(ByVal Pfad As String, Optional ByVal FehlerMelden As Boolean = False) As Boolean
        ' Zunächst davon ausgehen, dass Pfad nicht existiert
        Dim Validiert As Boolean = False

        Try
            ' Wenn Pfad nicht existiert, dann...
            If My.Computer.FileSystem.DirectoryExists(Pfad) = False Then
                ' ... anlegen
                My.Computer.FileSystem.CreateDirectory(Pfad)
            End If

            ' Pfad existiert
            Validiert = True

            ' Im Fehlerfall...
        Catch ex As Exception
            ' ... Fehler melden
            If FehlerMelden = True Then
                MessageBox.Show("Fehler beim Zugriff auf folgenden Ordner:" & vbCr & Pfad, AppName, MessageBoxButtons.OK, MessageBoxIcon.Error)
            End If
        End Try

        ' Ergebnis zurückgeben
        Return Validiert
    End Function
End Module
