# EventWatch.ps1 (c) c't/Peter Siering, GPLv3
# Fragt Ereignisprotokoll auf Fehler und kritische
# Ereignisse ab und schickt E-Mail, wenn diese nicht
# auf einer schwarzen Liste stehen.
# Weitere Hinweise in c't 10/2012, S. 148

# Aufrufpfad bestimmen, dort Variablen einlesen 
$myhome= Split-Path $MyInvocation.MyCommand.Path
try { . "$myhome/EventWatch_vars.ps1" }
catch {
    Write-Error -ErrorRecord $_
    exit 1
}

# Ausnahmeliste holen, wenn URL, sonst lokal
if ( $blacklisturl -ne "") {
    try { 
        $wget= New-Object System.Net.Webclient
        $wget.DownLoadFile($blacklisturl,"$myhome/blacklist.xml") 
    }
    catch { Write-Warning "Error fetching blacklist" }
}
try { $blacklist= import-clixml "$myhome/blacklist.xml" }
catch { $blacklist= @() }

# Zeitpunkt merken
$startdate= Get-Date

# Zeitpunkt des letzten Laufes, sonst vergangene 12 Stunden
try { $lasttimestamp= Import-Clixml $env:temp\event_watch.xml }
catch { $lasttimestamp= $startdate-(New-TimeSpan -hour 12) }

# Kritische Ereignisse (1) und Fehler (2) abfragen
$msgs=@()
$eventcount=0
foreach ( $level in @(1, 2)) {
    # Ereignisprotokoll(e) auslesen
    $events= Get-WinEvent -FilterHashTable @{ 
             LogName = '*'; level = $level; Starttime=$lasttimestamp } `
             -MaxEvents 30
    $eventcount+= ($events | Measure-Object).Count
    
    # Weiterverarbeitung nur, wenn Nachrichten vorliegen
    if ( ($events | Measure-Object).Count -gt 0 ) {
        foreach ( $event in $events) {
            $msg=$event.Message
            $logname=$event.LogName
            if ( $logname) { $logname=$logname -ireplace( "Microsoft-Windows-", "") }
            $provname=$event.ProviderName
            if ( $provname) { $provname=$provname -ireplace( "Microsoft-Windows-", "") }
            if ( $logname.Contains( $provname)) { $logname="" }
            if (( $provname -eq $logname) -or ( $logname -eq "")) { 
                $msg= ( $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
            } else {
                $msg= ( $logname + "/"+ $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
            }
            
            # Gegen Blacklist pruefen
            foreach ( $line in $blacklist) {
                if ( $msg -like $line) {
                    $msg=""
                    $eventcount--
                    break
                }
            }
            if ( $msg -ne "") { $msgs+= $msg }
        }
    } else { $msg="" }
}

# nur etwas ausgeben, wenn Ereignisse vorliegen
if ( $eventcount -eq 0) { 
    # Datum der Abfrage merken 
    $startdate | export-clixml $env:temp\event_watch.xml
    exit 0
}

# Nachrichtentext zusammenstellen
$OFS="`r`n`r`n"
$msgstxt=[string]($msgs)
$msgstxt="Kritische Ereignisse oder Fehler auf "+ $hostname +":`n`n"+ $msgstxt

# Ohne Mailserver ausgeben und Abflug
if ( $smtpserver -eq "mailhorst.example.com") {
    $msgstxt
    exit 0
}

# Mail schicken
$subject="[event_watch] $hostname"
try { $mail= New-Object Net.Mail.SmtpClient( $smtpserver, $smtpport) }
catch { 
    Write-Error -ErrorRecord $_
    exit 1
}
$mail.EnableSsl = $ssl
$mail.Credentials= New-Object System.Net.NetworkCredential( $smtpuser, $smtppass)
try { $mail.Send( $from, $to, $subject, $msgstxt) }
catch 
{ 
    Write-Error -ErrorRecord $_
    exit 1
}

# Erst jetzt Datum der letzten Abfrage wegschreiben
$startdate | export-clixml $env:temp\event_watch.xml
