//
//  ViewController.h
//  PingPong
//
//  Created by Abgottspon Andy on 23/09/2011.
//  Copyright (c) 2011 aaweb. All rights reserved.
//

#pragma once

#import <UIKit/UIKit.h>
#import "GestureLibrary.h"

@class SetupViewController;

@interface RootViewController : UIViewController
{
    SetupViewController *gestLibController;
    NSMutableDictionary *gestLibData;
    IBOutlet UIView *gestLibView;
    IBOutlet UIImageView *camView;
    IBOutlet UIScrollView *scrollView;
    IBOutlet UIButton *btnHand1;
    IBOutlet UIButton *btnHand2;
    IBOutlet UIButton *btnPrev;
    IBOutlet UIButton *btnNext;
    IBOutlet UIButton *btnFav;
    IBOutlet UIButton *btnTrash;
    NSMutableArray *imageArray;
    int nbOfPictures;
    int scrollStep;
    BOOL grabInProgress;
    BOOL doubleGrabbed;
    int activeImg;
    int h1x;
    int h1y;
    int h2x;
    int h2y;
    float camViewRatio;
    CGPoint grabPoint;
    int grabHand;
    float scaleFactor;
    CGRect grabbedImageFrame;
}

- (void)archiveImage:(int)imgNb folder:(int)isTrash;
- (void)scrollToActiveImage;
- (void)cancelGrab;
- (IBAction)update;
- (IBAction)grabEvent:(int)handId;
- (IBAction)releaseEvent:(int)handId;
- (IBAction)doubleGrabEvent;
- (IBAction)doubleReleaseEvent;
- (IBAction)swipeLeftEvent:(int)handId;
- (IBAction)swipeRightEvent:(int)handId;
- (IBAction)showSetup:(id)sender;
- (IBAction)prevPicture:(id)sender;
- (IBAction)nextPicture:(id)sender;

- (BOOL)isPoint:(CGPoint)p withinRect:(CGRect)rect;
+ (UIImage *)imageWithImage:(UIImage *)image scaledToSize:(CGSize)newSize;

@property (readonly, retain) SetupViewController *gestLibController;
@property (readwrite, assign) NSMutableDictionary *gestLibData;
@property (readwrite, assign) UIImageView *camView;

@end
