//
//  SetupViewController.m
//  Meteora
//
//  Created by Abgottspon Andy on 24/09/2011.
//  Copyright (c) 2011 aaweb. All rights reserved.
//

#import "SetupViewController.h"
#import "ofMain.h"
#import "ofxiPhone.h"
#import "ofxiPhoneExtras.h"
#import "ofxOpenCv.h"
#import "ofxiPhoneVideoGrabber.h"
#import "GestureLibrary.h"
#import "ofxVectorMath.h"
#import "ofxiPhoneAppDelegate.h"


@implementation SetupViewController
@synthesize gestLib;
@synthesize videoWidth;
@synthesize videoHeight;


- (id)initWithRootVC:(RootViewController *)vc
{
    rootVC = vc;    
    
    return self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    // Init and setup gesture library
    videoWidth = 352;
    videoHeight = 288;
    fps = 15.0;
    camViewScale = (float)camImg.frame.size.width / (float)videoWidth;
    camScreenScale = (float)[self view].frame.size.width / (float)videoWidth;
    
    gestLib.setup(videoWidth, videoHeight, [thresholdSlider value]); // w, h and threshold       
    gestLib.setHandColor(0.0, 255.5, 216.0); // set default hand color
    
    // Flip view vertically
    camImg.transform = CGAffineTransformMakeScale(1.0, -1.0); 
    rootVC.camView.transform = CGAffineTransformMakeScale(1.0, -1.0); 

    // Default values
    [self enabledChanged:enabledSwitch]; // sync UI with setting, start timer!
    
    // Setup tap event for color calibration
    UITapGestureRecognizer *singleFingerTap = [[UITapGestureRecognizer alloc]
                                                initWithTarget:self action:@selector(handleSingleTap:)];
    singleFingerTap.numberOfTapsRequired = 1;
    [camImg addGestureRecognizer:singleFingerTap];
    [singleFingerTap release];
    
}
- (void)update
{
    // Update gesture library (hand and gestures)
    gestLib.update();    
    
    // Process gestures in library now
    bool gestureDone = gestLib.processGestures();

    // Determine number of hands, but maximum 2 since we only have support for 2 hands in the UI
    int nbOfHands = gestLib.getHands().size() > 2 ? 2 : gestLib.getHands().size(); 
    
    // Hidel labels at first, then unhide them later when needed
    lblHand1.hidden = YES;
    lblHand2.hidden = YES;
    
    // Adjust hands
    for(int i=0; i < nbOfHands; i++)
    {
        Hand hand = gestLib.getHands()[i];
        ofRectangle handRect = gestLib.getHands()[i].getRect();
        
        // Set hand rectangle and other attributes for handOne and handTwo
        UILabel *handLbl;
        if(i == 0) {
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getPosition().x] forKey:@"handOnePosX"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getPosition().y] forKey:@"handOnePosY"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getRect().width] forKey:@"handOneWidth"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getRect().height] forKey:@"handOneHeight"];
            
            handLbl = lblHand1;
        } else {
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getPosition().x] forKey:@"handTwoPosX"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getPosition().y] forKey:@"handTwoPosY"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getRect().width] forKey:@"handTwoWidth"];
            [rootVC.gestLibData setObject:[NSNumber numberWithInt:hand.getRect().height] forKey:@"handTwoHeight"];

            handLbl = lblHand2;
        }
        
        handLbl.frame = CGRectMake(handRect.x*camViewScale + camImg.frame.origin.x, 
                                    handRect.y*camViewScale + camImg.frame.origin.y,
                                    handRect.width*camViewScale,
                                    handRect.height*camViewScale);
        handLbl.hidden = NO;
       
        if(gestureDone) { // When gesture completed, so only once
        
            switch (gestLib.getHands()[i].getGesture()) {
                case GEST_GRAB:
                    handLbl.text = @"Grab";
                    [rootVC grabEvent:i];
                    break;
                    
                case GEST_RELEASE:
                    handLbl.text = @"Release";
                    [rootVC releaseEvent:i];
                    break;
                    
                case GEST_SWIPE_LEFT:
                    handLbl.text = @"<<";
                    [rootVC swipeLeftEvent:i];
                    break;
                    
                case GEST_SWIPE_RIGHT:
                    handLbl.text = @">>";
                    [rootVC swipeRightEvent:i];
                    break;
                    
                default:
                    handLbl.text = @"";
                    break;
            }
        } else {
            handLbl.text = @"";
        }
    }

    [rootVC.gestLibData setObject:[NSNumber numberWithInt:nbOfHands] forKey:@"nbOfHands"];
    [rootVC.gestLibData setObject:[NSNumber numberWithInt:gestLib.getDoubleGesture()] forKey:@"doublegesture"];
    
    switch (gestLib.getDoubleGesture()) {
        case GEST_GRAB:
            [rootVC doubleGrabEvent];
            break;
            
        case GEST_RELEASE:
            [rootVC doubleReleaseEvent];
            break;
            
        default:
            break;
    }
    
    
    // Assign image to view if it is visible
    if(![self.view isHidden]) {
        camImg.image = [UIImage imageWithCGImage:gestLib.getCurrentFrame()];
    } else {
        rootVC.camView.image = [UIImage imageWithCGImage:gestLib.getCurrentFrame()];
    }
    
    [rootVC update];
}

- (void)handleSingleTap:(UIGestureRecognizer *)sender
{
    // Get tap point
    CGPoint tapPoint = [sender locationInView:[self view]];
    
    // Take imageview position into consideration
    int x = (tapPoint.x - camImg.frame.origin.x) * 1.0/camViewScale;
    int y = (tapPoint.y - camImg.frame.origin.y) * 1.0/camViewScale;
    
    // Get color at that pixel and set it as new reference color
    NSLog(@"Get color at %d %d", x, y);
    ofColor refColor = gestLib.getColor(x , y);
    gestLib.setHandColor(refColor);   
    
    lblColor.backgroundColor = [UIColor colorWithRed:refColor.r/255.0 green:refColor.g/255.0 blue:refColor.b/255.0 alpha:1.0];
}

- (IBAction)done:(id)sender
{
    // Kill timer
//    [timer invalidate];
//    timer = nil;
    
    // ... and hide view
    [self.view setHidden:YES];
}


- (IBAction)thresholdChanged:(id)sender
{
    gestLib.setColorThreshold((int)[thresholdSlider value]);
}

- (IBAction)enabledChanged:(UISwitch *)sender
{
    int enabled = ([sender isOn]) ? 1 : 0;
    [rootVC.gestLibData setObject:[NSNumber numberWithInt:enabled] forKey:@"enabled"];

    // Re-create or kill timer
    if([sender isOn]) {
        timer = [NSTimer scheduledTimerWithTimeInterval:1.0/fps target:self selector:@selector(update) userInfo:nil repeats:YES];
    } else {
        [timer invalidate];
        timer = nil;
    }
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return YES;
}

@end
