# Ausnahmeliste holen
try { $wget= New-Object System.Net.Webclient
$wget.DownLoadFile("http://agent.ct.heise.de/blacklist.xml","blacklist.xml")
$blacklist= import-clixml blacklist.xml }
catch { $blacklist= @() }
# Zeitpunkt des letzten Laufes, sonst vergangene 15 Minuten
try { $lasttimestamp= import-clixml $env:temp\check_events_ts.xml }
catch { $lasttimestamp= (get-date)-(New-TimeSpan -minute 60) }
(get-date) | export-clixml $env:temp\check_events_ts.xml
# Kritische Ereignisse (1) und Fehler (2) abfragen
$msgs=@()
$eventcount=@(0, 0, 0)
foreach ( $level in @(1, 2)) {
    $events= Get-WinEvent -FilterHashTable @{ 
             LogName = '*'; level = $level; Starttime=$lasttimestamp } `
             -MaxEvents 30 -EA SilentlyContinue
    $eventcount[$level]= ($events | Measure-Object).Count
    if ( $eventcount[$level] -gt 0 ) {
        foreach ( $event in $events) {
            $msg=$event.Message
            if ( $msg) { $msg=$msg.replace( "`n"," ") }
            $logname=$event.LogName
            if ( $logname) { $logname=$logname.replace( "Microsoft-Windows-", "") }
            $provname=$event.ProviderName
            if ( $provname) { $provname=$provname.replace( "Microsoft-Windows-", "") }
            if ( $logname.Contains( $provname)) { $logname="" }
            if (( $provname -eq $logname) -or ( $logname -eq "")) { 
                $msg= ( $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
            } else {
                $msg= ( $logname + "/"+ $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
            }
            foreach ( $line in $blacklist) {
                if ( $msg -like $line) { $msg=""; $eventcount[$level]--; break }
            }
            if ( $msg -ne "") { $msgs+= $msg }
        }
    } else { $msg="" }
}
if (( $eventcount[1] -eq 0) -and ( $eventcount[2] -eq 0)) {
  Write-host "OK - no critical/error events"; exit 0 }
$msgstxt=[string]($msgs)
# Haesslich aber O.K. http://powershell.com/cs/blogs/tobias/archive/2011/04/28/multiple-text-replacement-challenge.aspx
$msgstxt=$msgstxt.replace(""+[char]0x00f6,"oe").replace(""+[char]0x00e4,"ae").replace(""+[char]0x00fc,"ue").`
  replace(""+[char]0x00d6,"Oe").replace(""+[char]0x00c4,"Ae").replace(""+[char]0x00dc,"Ue").replace(""+[char]0x00df,"ss")
if ( $msgstxt.Length -gt 513) { $msgstxt=$msgstxt.SubString(0,512)+"..." }
if ( $eventcount[1] -gt 0) 
{ Write-host "CRITICAL -"$eventcount[1]"/"$eventcount[2] `
  "critical/error events - $msgstxt"; exit 2 }
Write-host "WARNING -"$eventcount[2]"error events - $msgstxt"; exit 1
