# ct_checkintelraid.ps1 (c) c't/Peter Siering, GPLv3
# Fuehlt Intel-Software-RAID auf den Zahn, um
# mit Nagios gegebenenfalls Alarm zu schlagen
# Weitere Hinweise in c't 12/2012, S. 184

# Laueft der zustaendige Dienst noch?
$service=Get-Service -Name megamonitorsrv | 
    Where-Object {$_.Status -eq "Running"} | Measure-Object
if ( $service.count -eq 0 ) {
    "ERR - monitor service died"
    exit 2
}

# Hat er in den letzten 24 Stunden etwas protokolliert,
# das mehr als nur eine Information ist?
$events=Get-WinEvent -LogName "Application" `
    -FilterXPath "*[System[Provider[@Name='MR_MONITOR'] and 
                  (Level=1 or Level=2 or Level=3) and
                  TimeCreated[timediff(@SystemTime) <= 86400000]]]" `
    -EA SilentlyContinue | Measure-Object
if ( $events.count -eq 0 ) {
    "OK - no events, service is running & sun shining"
    exit 0
}
"ERR - "+ $events.count +" events logged"
exit 2