﻿using Actien.Data;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.ApplicationSettings;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// Die Elementvorlage "Benutzersteuerelement" ist unter http://go.microsoft.com/fwlink/?LinkId=234236 dokumentiert.

namespace Actien.UI
{
    public sealed partial class StockSettings : UserControl
    {
        SettingsHolder _options;
        public SettingsHolder Options
        {
            get { return _options; }
        }

        public StockSettings(SettingsHolder options)
        {
            _options = options;
            this.InitializeComponent();
            Options.PropertyChanged += SettingsChanged;
        }

        private void SettingsChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HistoryDays")
            {
            }
        }

        private void BackClicked(object sender, RoutedEventArgs e)
        {
            if (this.Parent.GetType() == typeof(Popup))
            {
                ((Popup)this.Parent).IsOpen = false;
            }
            SettingsPane.Show();
        }

        private void lstSymbols_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            btnDelete.IsEnabled = (lstSymbols.SelectedIndex != -1);
        }

        private void btnDelete_Click(object sender, RoutedEventArgs e)
        {
            StockQuote sel = lstSymbols.SelectedItem as StockQuote;
            if (sel != null)
            {
                edtSymbol.Text = sel.Symbol;
                _options.Quotes.Remove(sel);
            }
        }

        private void edtSymbol_TextChanged(object sender, TextChangedEventArgs e)
        {
            btnAdd.IsEnabled = !string.IsNullOrEmpty(edtSymbol.Text);
        }

        private async void btnAdd_Click(object sender, RoutedEventArgs e)
        {
            string sym = edtSymbol.Text;
            if (!string.IsNullOrEmpty(sym))
            {
                StockQuote sq = new StockQuote(sym);
                _options.Quotes.Add(sq);
                bool dummy = await sq.LoadData();
                sq.LoadHistory(DateTime.Today.AddDays(-Options.HistoryDays), DateTime.Today);
                lstSymbols.ScrollIntoView(sq);
                lstSymbols.SelectedItem = sq;
            }
        }

    }
}
