package de.USERNAME.mahout;

import java.util.*;

import org.apache.mahout.classifier.*;
import org.apache.mahout.classifier.bayes.algorithm.BayesAlgorithm;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.datastore.InMemoryBayesDatastore;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.interfaces.Datastore;
import org.apache.mahout.classifier.bayes.model.ClassifierContext;
import org.apache.mahout.common.nlp.NGrams;

public class TweetClassifier {
	public static void main(String[] args) throws Exception {
		/* Beispiel-Tweet */
		String tweet = "erst mal eine schöne bionade trinken";
		
		/* Ort, an dem das Klassifikationsmodell liegt */
		String modelDir = "hdfs://localhost/user/USERNAME/softdrink";

		/* Konfigurationsparameter für den Klassifikator */
		BayesParameters bparams = new BayesParameters();
	     	bparams.set("verbose", "true");
		bparams.set("classifierType", "bayes");	
		bparams.set("dataSource", "hdfs");
		bparams.set("defaultCat", "unknown");
		bparams.set("encoding", "UTF-8");
		bparams.set("alpha_i", "1.0");
		bparams.set("basePath", modelDir);
		bparams.set("gramSize", "1");

		/* Bayes-Algorithmus */
		Algorithm algorithm = new BayesAlgorithm();
		Datastore datastore = new InMemoryBayesDatastore(bparams);

		/* Klassifikator initialisieren */
		ClassifierContext classifier = new ClassifierContext(algorithm,datastore);
                classifier.initialize();
		
		/* Tweet klassifizieren */
		Collection<String> labels = classifier.getLabels();
		ResultAnalyzer resultAnalyzer = new ResultAnalyzer(labels, bparams.get("defaultCat"));
		List<String> document = new NGrams(tweet, Integer.parseInt(bparams.get("gramSize"))).generateNGramsWithoutLabel();
		ClassifierResult result = classifier.classifyDocument(document.toArray(new String[document.size()]),bparams.get("defaultCat"));
		System.out.println("Tweet '"+tweet+"' ist " + result.getLabel());
	}
}


