/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.CyclicBarrier;

public class spectralnorm {
    private static final NumberFormat formatter = new DecimalFormat("#.000000000");

    public static void warmUp(String[] stringArray) {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            spectralnorm.benchmark(stringArray);
            if (i != 9) {
                System.out.print(++n + ", ");
                continue;
            }
            System.out.println(++n + ";");
        }
    }

    public static void benchmark(String[] stringArray) {
        int n = 10000;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        spectralnorm.spectralnormGame(n);
    }

    public static void main(String[] stringArray) {
        System.out.println("Starte WarmUp ...");
        spectralnorm.warmUp(stringArray);
        System.out.println("Beende WarmUp ...");
        long l = System.currentTimeMillis();
        spectralnorm.benchmark(stringArray);
        long l2 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l2 - l) + " ms");
    }

    private static final double spectralnormGame(int n) {
        int n2;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = 1.0;
        }
        n2 = Runtime.getRuntime().availableProcessors();
        Approximate.barrier = new CyclicBarrier(n2);
        int n3 = n / n2;
        Approximate[] approximateArray = new Approximate[n2];
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n3;
            int n5 = i < n2 - 1 ? n4 + n3 : n;
            approximateArray[i] = new Approximate(dArray, dArray2, dArray3, n4, n5);
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            try {
                approximateArray[i].join();
                d += approximateArray[i].m_vBv;
                d2 += approximateArray[i].m_vv;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return Math.sqrt(d / d2);
    }

    private static class Approximate
    extends Thread {
        private static CyclicBarrier barrier;
        private double[] _u;
        private double[] _v;
        private double[] _tmp;
        private int range_begin;
        private int range_end;
        private double m_vBv = 0.0;
        private double m_vv = 0.0;

        public Approximate(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
            this._u = dArray;
            this._v = dArray2;
            this._tmp = dArray3;
            this.range_begin = n;
            this.range_end = n2;
            this.start();
        }

        @Override
        public void run() {
            int n;
            for (n = 0; n < 10; ++n) {
                this.MultiplyAtAv(this._u, this._tmp, this._v);
                this.MultiplyAtAv(this._v, this._tmp, this._u);
            }
            for (n = this.range_begin; n < this.range_end; ++n) {
                this.m_vBv += this._u[n] * this._v[n];
                this.m_vv += this._v[n] * this._v[n];
            }
        }

        private static final double eval_A(int n, int n2) {
            int n3 = ((n + n2) * (n + n2 + 1) >>> 1) + n + 1;
            return 1.0 / (double)n3;
        }

        private final void MultiplyAv(double[] dArray, double[] dArray2) {
            for (int i = this.range_begin; i < this.range_end; ++i) {
                double d = 0.0;
                for (int j = 0; j < dArray.length; ++j) {
                    d += Approximate.eval_A(i, j) * dArray[j];
                }
                dArray2[i] = d;
            }
        }

        private final void MultiplyAtv(double[] dArray, double[] dArray2) {
            for (int i = this.range_begin; i < this.range_end; ++i) {
                double d = 0.0;
                for (int j = 0; j < dArray.length; ++j) {
                    d += Approximate.eval_A(j, i) * dArray[j];
                }
                dArray2[i] = d;
            }
        }

        private final void MultiplyAtAv(double[] dArray, double[] dArray2, double[] dArray3) {
            try {
                this.MultiplyAv(dArray, dArray2);
                barrier.await();
                this.MultiplyAtv(dArray2, dArray3);
                barrier.await();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

