#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# html2css: Generates a css template from a html structure
# version: 0.2
# runs with python 2.7.5 and newer
#
# Reiko Kaps <rek@ct.de> 2013
# http://ct.de

import argparse, sys
try:
	from bs4 import BeautifulSoup
except:
	print("Das Python-Modul BeautifulSoup4 fehlt, bitte installieren Sie es.")
	print("Beispiel: pip install beautifulsoup4 oder über Distributionstools.\n")
	sys.exit()

parser = argparse.ArgumentParser(description='Generates a css template from a html structure')
parser.add_argument('-f', '--file', help='HTML-File')

args = parser.parse_args()
if not args.file:
	parser.print_help()
	sys.exit()

# open file
soup = BeautifulSoup(open(args.file))

##
# Tag-Liste. Selectoren
tags = list()
selectors = list()
id_list = list()
class_list = list()

##
# print to stdout
def print_out(name, element_list):	
	"""Print all elements of elements_list as css declaration *"""
	print("\n/* -- Identifier {} */".format(name))
	for element in sorted(element_list):
		if name == 'id':
			print("#"+element+" { }")
		elif name == 'class':
			print("."+element+" { }")
		else:
			print(element+" { }")
	return

##
# print a nice header 
def print_header(filename):
	"""Print a nice header ..."""
	print("/***********************************************************")
	print(" * All #id, .class, tags and selector from ")
	print(" * {} ".format(filename))
	print("************************************************************/")
	return

# if body not exists, get all
if soup.findAll('body'):
	content = soup.html.body.findAll()
else:	
	content = soup.findAll()
	
##
# main loop
for tag in content:
	# tags einsammeln
	tags.append(tag.name)
	
	# eltern-elemente einsammeln 
	# und umgekehrt einfügen
	eltern = list()
	for parent in tag.parents:
		if parent is not None:
			# document ausnehmen
			if parent.name != '[document]' and parent.name != 'body' and parent.name != 'html':
				eltern.append(parent.name)
					
	tag_path = ""
	for item in reversed(eltern):	
		tag_path = tag_path + item + " > "	
	selectors.append(tag_path + tag.name)
		
	# get id
	if tag.get('id'):
		id_list.append(tag.get('id'))
		
	# get all classes
	if tag.get('class'):
		for klasse in tag.get('class'):
			class_list.append(klasse)
	
##
# print all
print_header(args.file)
print_out('id', set(id_list))
print_out('class', set(class_list))
print_out('tag', set(tags))
print_out('selector', set(selectors))
sys.exit()
