#!/usr/bin/perl -w
use POSIX;
use strict;

# file with all usernames / passwords
my $pwfile = '/etc/openvpn/passwd';

# Get username/password from temp file
my $ARG;
if ($ARG = shift @ARGV) {
    if (!open (UPFILE, "<$ARG")) {
        print "Could not open username/password file: $ARG\n";
        exit 1;
    }
} else {
    print "No username/password file specified on command line\n";
    exit 1;
}

my $username = <UPFILE>;
my $password = <UPFILE>;

if (!$username || !$password) {
    print "Username/password not found in file: $ARG\n";
    exit 1;
}

chomp $username;
chomp $password;

close (UPFILE);

# check if this combination is valid
if (!open (PWFILE, "<$pwfile")) {
    print "Could not open passwd file: $pwfile\n";
    exit 1;
}

while (my $line = <PWFILE>) {
    if ($line =~ /^${username}:${password}$/) {
	exit 0;
    }
}
print "Auth '$username' failed\n";
exit 1;