void print_compilerinfo(void) {
#if defined __INTEL_COMPILER

	printf("compiled with Intel Compiler V%5.2f", (double)__INTEL_COMPILER / 100);
#if defined __INTEL_COMPILER_BUILD_DATE
	printf(", Build %d", __INTEL_COMPILER_BUILD_DATE);
#endif 
#if defined _MSC_VER 
	printf(", with MSVC %5.2f", (double)_MSC_VER / 100);
#endif 

#elif defined _MSC_VER 
	printf("Microsoft Visual C V %5.2f", (double)_MSC_VER / 100);
#ifdef _MSC_FULL_VER
	printf(" %d", _MSC_FULL_VER);
#endif
#ifdef _MSC_BUILD
	printf(".%d", _MSC_BUILD);
#endif
#endif;


#if defined(__cplusplus)
	printf(", C++");
#else 
	printf(", C");
#endif;

	printf("\n");


#if defined WIN64 || defined _WIN64
	printf("Windows 64");
#else 
#if defined WIN32 
	printf("Windows 32");
#endif;
#endif;

#if defined linux 
	printf("linux");
#endif 

#if defined unix 
	printf(", unix");
#endif 

#if defined __x86_64 || defined _M_IX64 || defined _AMD64_
	printf(", target: x86_64");
#endif; 

#if defined __ia64
	printf(", target: IA64");
#endif; 



#if defined __i386 || defined _M_IX86
	printf(", target: x86-32");
#if defined _M_IX86 
	printf(" for processor %d", _M_IX86);
#endif; 
#endif;

#if defined _M_IX86_FP 
	printf(", _M_IX86_FP= %d", _M_IX86_FP);
#endif 


#if defined _DEBUG
	printf(" debug, ");
#else 
	printf(" Release, ");
#endif;

#if defined _DLL
	printf("RTL-DLL, ");
#else 
	printf("RTL embedded., ");
#endif;

#if defined _MT 
	printf("Multi Threaded, ");
#else 
	printf("Single Threaded, ");
#endif

#if defined _OPENMP
	printf("openmp= %d", _OPENMP);
#endif; 

#if defined _PGO_INSTRUMENT
	printf(", openmp= %d", _OPENMP);
#endif; 

#ifdef _AVX_ 
#ifndef _AVX 
#define _AVX 
#endif 
#endif

#ifdef _PLATFORM 
	printf(" Platformtoolset v%d\n", _PLATFORM);
#endif  

	printf("\n");
	printf("Options=");

#ifdef _IA32
	printf(" IA32");
#endif

#ifdef _SSE2 
	printf(" SSE2");
#endif
#ifdef _SSE3
	printf(" SSE3");
#endif
#ifdef _AVX
	printf(" AVX");
#endif
#ifdef _AVX1 
	printf(" AVX1");
#endif
#ifdef _AVX2
	printf(" AVX2");
#endif


#ifdef _OPTMUL
	printf(" OPTMUL");
#endif

#ifdef _SEQUENTIAL
	printf(" MKL_SEQUENTIAL");
#endif

#ifdef _PARALLEL
	printf(" MKL_PARALLEL");
#endif

#ifdef novec
		printf(" No Vectorization");
#endif






	printf("\n");
}